/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.deadline;

import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.deadlines.DeadLineScheduler;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.DeadlineInstancesDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadlineInstance;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.Registry;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RemoveDeadlineHandler
extends APIHandler {
    private HTSDeadline.DEADLINE_TYPE _dType;

    public RemoveDeadlineHandler(HTSDeadline.DEADLINE_TYPE type) {
        this._dType = type;
    }

    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        if (context != null) {
            List<HTSDeadlineInstance> deadlines;
            HTSTask task = context.getPersistedTask();
            if (task == null) {
                Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_INVALID_PARAMETER, new Object[]{"ID", context.getOperationName(), context.getTaskId()});
            }
            if ((deadlines = task.getHtsDeadlineInstance()) != null) {
                Iterator<HTSDeadlineInstance> iDeadlines = deadlines.iterator();
                ArrayList<HTSDeadlineInstance> deletedDeadLines = new ArrayList<HTSDeadlineInstance>();
                while (iDeadlines.hasNext()) {
                    DeadlineInstancesDAO dao;
                    int deleted;
                    HTSDeadlineInstance inst = iDeadlines.next();
                    HTSDeadline deadline = inst.getHtsDeadline();
                    if (!this._dType.equals((Object)HTSDeadline.DEADLINE_TYPE.valueOf(deadline.getHtsDeadlinetype())) || (deleted = (dao = DAOFactory.getFactory().buildDeadlineInstancesDAO()).deleteById(inst.getId())) != 1) continue;
                    deletedDeadLines.add(inst);
                    Registry.getService(DeadLineScheduler.class).deadlineInstanceRemoved();
                }
                deadlines.removeAll(deletedDeadLines);
            }
        }
        this.handleNextRequest(context);
    }
}

