/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.security.IAuthenticator;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;

public class AuthenticationHandler
extends APIHandler
implements IAPIHandler {
    private static boolean doFault = false;
    private static boolean doAuthenticate = true;

    public AuthenticationHandler(IAPIHandler handler) {
        this.setSuccessor(handler);
    }

    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        if (doAuthenticate) {
            BiBusHeader header = context.getHeader().getBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            IAuthenticator authenticator = AuthenticatorFactory.getInstance();
            if (doFault) {
                HumanTaskServiceException htse = new HumanTaskServiceException(UsI18NCode.MSG_HTS_AUTHENTICATION_ERROR, new Object[]{"test"}, new Exception());
                throw htse;
            }
            try {
                authenticator.authenticate(headers);
            }
            catch (SDKClientException e) {
                HumanTaskServiceException htse = new HumanTaskServiceException(UsI18NCode.MSG_HTS_AUTHENTICATION_ERROR, new Object[]{e.getLocalizedMessage()}, e);
                throw htse;
            }
            catch (EMFSecurityException e) {
                HumanTaskServiceException htse = new HumanTaskServiceException(UsI18NCode.MSG_HTS_AUTHENTICATION_ERROR, new Object[]{e.getLocalizedMessage()}, e);
                throw htse;
            }
        }
        this.handleNextRequest(context);
    }

    public static void setAuthenticate(boolean auth) {
        doAuthenticate = auth;
    }

    static void setFault(boolean fault) {
        doFault = fault;
    }
}

