/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.Headers;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.TargetStatus;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallback;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.callback.ClientCallbackFactory;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.CallbackUtilities;
import com.ibm.cognos.internal.hts.util.dao.MessageUtils;
import com.ibm.cognos.internal.hts.util.dao.StatusUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;

public class CallBackHandler
extends APIHandler
implements IAPIHandler {
    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        HTSCallback callback = this.findCallback(context);
        HTSTask task = context.getPersistedTask();
        TargetStatus statusContext = this.getTargetStatusContext(context, task);
        if (callback != null) {
            this.doCallback(context, statusContext, callback);
        } else {
            StatusUtils.setStatus(task, statusContext.getTargetStatus(), null);
        }
        this.handleNextRequest(context);
    }

    private HTSCallback findCallback(IAbstractContext context) {
        return context.getPersistedTask().getHtsCallback();
    }

    private void doCallback(IAbstractContext context, TargetStatus targetStatusInfo, HTSCallback callback) throws HumanTaskServiceException {
        TStatus.Enum targetStatus = targetStatusInfo.getTargetStatus();
        HTSTask task = context.getPersistedTask();
        if (TStatus.ERROR.equals(targetStatus) || TStatus.FAILED.equals(targetStatus)) {
            this.doErrorCallback(context, targetStatusInfo, callback);
            StatusUtils.setError(task, targetStatusInfo.getError());
        } else if (TStatus.OBSOLETE.equals(targetStatus)) {
            this.doCancelCallback(context, targetStatusInfo, callback);
            StatusUtils.setStatus(task, targetStatus, null);
        } else if (TStatus.COMPLETED.equals(targetStatus)) {
            CallbackUtilities.addCallbackParameter(CallbackUtilities.STATUS_FLAG_REF_PARAM, targetStatusInfo.getTargetStatus().toString(), callback);
            this.callback(context, callback, targetStatus, new Object[]{targetStatusInfo.getOutputData()});
            StatusUtils.setComplete(task);
        } else {
            Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_INVALID_STATUS, new Object[]{targetStatus, "complete"});
        }
    }

    private TargetStatus getTargetStatusContext(IAbstractContext context, HTSTask task) throws HumanTaskServiceException {
        TargetStatus targetStatusContext = null;
        if (context instanceof TargetStatus) {
            targetStatusContext = (TargetStatus)((Object)context);
        }
        return targetStatusContext;
    }

    private void doCancelCallback(IAbstractContext context, TargetStatus targetStatusInfo, HTSCallback callback) throws HumanTaskServiceException {
        CallbackUtilities.addCallbackParameter(CallbackUtilities.STATUS_FLAG_REF_PARAM, targetStatusInfo.getTargetStatus().toString(), callback);
        this.callback(context, callback, targetStatusInfo.getTargetStatus(), new Object[0]);
    }

    private void doErrorCallback(IAbstractContext context, TargetStatus targetStatusInfo, HTSCallback callback) throws HumanTaskServiceException {
        Object[] objectArray;
        HTSMessage message = MessageUtils.getFaultMessage(context.getPersistedTask());
        if (message == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = message.getMessage();
        }
        Object[] errorMessage = objectArray;
        CallbackUtilities.addCallbackParameter(CallbackUtilities.STATUS_FLAG_REF_PARAM, targetStatusInfo.getTargetStatus().toString(), callback);
        this.callback(context, callback, targetStatusInfo.getTargetStatus(), errorMessage);
    }

    private void callback(IAbstractContext context, HTSCallback callback, TStatus.Enum status, Object[] args) throws HumanTaskServiceException {
        HTSTask task = context.getPersistedTask();
        Headers header = context.getHeader();
        this.authenticateHeader(header.getBiBusHeader());
        context.setResponseHeader(header);
        try {
            ClientCallbackFactory.getInstance(task.getHtsTaskclass()).callServerMethod(context, callback, task.getHtsTaskclass(), args);
        }
        catch (HumanTaskServiceException t) {
            StatusUtils.setError(task, t);
            Utils.throwHumanTaskServiceException((Throwable)((Object)t), UsI18NCode.MSG_US_CANNOT_COMPLETE, new Object[]{task.getName(), t.getMessage()});
        }
        catch (Throwable t) {
            Utils.logException(t);
            HumanTaskServiceException ex = new HumanTaskServiceException(UsI18NCode.MSG_US_CANNOT_COMPLETE, new Object[]{task.getName(), t.getMessage()});
            StatusUtils.setError(task, ex);
            Utils.throwHumanTaskServiceException((Throwable)((Object)ex));
        }
    }

    private void authenticateHeader(BiBusHeader header) {
        boolean authentic = false;
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        try {
            AuthenticatorFactory.getInstance().authenticate(headers);
            authentic = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!authentic) {
            try {
                AuthenticatorFactory.getInstance().logon(headers);
                authentic = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

