/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.RetryHandler;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.UserStoreHandler;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.LPGUserKey;
import com.ibm.cognos.internal.hts.util.cam.UserCollector;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CollectUsersHandler
extends APIHandler
implements IAPIHandler {
    private TGenericHumanRole[] roles;
    private TPeopleAssignments[] pas;

    public CollectUsersHandler(TGenericHumanRole[] roles) {
        this.roles = roles;
    }

    public CollectUsersHandler(TPeopleAssignments[] pas) {
        this.pas = pas;
    }

    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        UserCollector collector = new UserCollector();
        collector.collectUsers(this.roles);
        collector.collectUsers(this.pas);
        this.cacheUsers(collector.getUsers(), context);
        this.handleNextRequest(context);
    }

    private void cacheUsers(Set<HTSTaskUser> users, IAbstractContext context) throws HumanTaskServiceException {
        Map<String, Object> threadProps = null;
        ArrayList<HTSTaskUser> newUsers = new ArrayList<HTSTaskUser>(users);
        if (AbstractContext.getThreadProperties() != null && (threadProps = AbstractContext.getThreadProperties()) != null) {
            HashMap<LPGUserKey, HTSTaskUser> cachedUsers = (HashMap<LPGUserKey, HTSTaskUser>)threadProps.get("CACHED_USERS");
            if (cachedUsers == null) {
                cachedUsers = new HashMap<LPGUserKey, HTSTaskUser>();
                threadProps.put("CACHED_USERS", cachedUsers);
            }
            for (HTSTaskUser taskUser : users) {
                if (!cachedUsers.containsKey(taskUser.getLPGUserKey())) continue;
                newUsers.remove(taskUser);
            }
            new RetryHandler(new UserStoreHandler(newUsers, cachedUsers)).handleRequest(context);
        }
    }
}

