/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.event.EventStatusInfo;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.apiHandlers.CompleteApproveManualTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.CompleteManualTaskContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.BiBusNotifier;
import com.ibm.cognos.internal.hts.util.BiBusNotifierFactory;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class CompleteTaskTSEHandler
extends CompleteApproveManualTaskHandler {
    private static Set<TStatus.Enum> errorStates = new HashSet<TStatus.Enum>();

    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        CompleteManualTaskContext context = (CompleteManualTaskContext)aContext;
        BiBusNotifier notifier = BiBusNotifierFactory.getInstance();
        TStatus.Enum status = TStatus.Enum.forString((String)context.getStatus());
        if (status == null || TStatus.COMPLETED.equals(status)) {
            EventStatusInfo est = context.getOutputInterpreter().getEventStatusInfo();
            notifier.addHistoryDetail(context.getEventId(), UsI18NCode.MSG_US_APPROVAL_MSG, aContext.getLocale(), SeverityEnum.info, new Object[]{context.getOutputInterpreter().getOutcome()});
            notifier.callMonitorServiceNotify(context.getPassport(), context.getCredential(), context.getEventId(), 1, est.toString());
        } else if (errorStates.contains(status)) {
            if (TStatus.OBSOLETE.equals(status)) {
                String userName = UserUtils.instance().getUserName(context, context.getUsTaskUser());
                String message = I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_USV_TASK_HAS_BEEN_CANCELED, (Object[])new Object[]{userName}, (Locale)aContext.getLocale());
                notifier.callMonitorServiceAddErrorMsg(message, context.getEventId());
                EventStatusInfo est = new EventStatusInfo(EventStatus.FAILED);
                est.setInfo(new String[]{"none"});
                notifier.callMonitorServiceNotify(context.getPassport(), context.getCredential(), context.getEventId(), 1, est.toString());
            } else if (context.getCompleteData() != null) {
                notifier.callMonitorServiceAddErrorMsg(context.getCompleteData(), context.getEventId());
            } else {
                notifier.callMonitorServiceNotify(context.getPassport(), context.getCredential(), context.getEventId(), 1, EventStatus.FAILED.statusName());
            }
        } else {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.WARN, (I18NCode)UsI18NCode.MSG_US_CANNOT_COMPLETE, new Object[]{status});
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_CANNOT_COMPLETE);
        }
        this.handleNextRequest(context);
    }

    static {
        errorStates.add(TStatus.ERROR);
        errorStates.add(TStatus.EXITED);
        errorStates.add(TStatus.FAILED);
        errorStates.add(TStatus.OBSOLETE);
    }
}

