/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jms.client.BiBusMonitorUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallback;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallbackParam;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.dao.CallbackUtilities;
import java.util.List;

public class CreateManualTaskNotifyMSHandler
extends APIHandler
implements IAPIHandler {
    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        BiBusHeader header = context.getHeader().getBiBusHeader();
        HTSCallback hTSCallback = context.getPersistedTask().getHtsCallback();
        if (header != null && hTSCallback != null) {
            List<HTSCallbackParam> params = hTSCallback.getHtsCallbackparams();
            String eventID = null;
            for (HTSCallbackParam callbackparam : params) {
                String refParameterName = callbackparam.getQname();
                if (refParameterName.equals(CallbackUtilities.EVENT_ID_REF_PARAM.toString())) {
                    eventID = callbackparam.getValue();
                    break;
                }
                SDSLogger.getLogger((SDSCategory)USCategory.AUDIT).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_US_CREATE_MANUAL_TASK);
                SDSLogger.getLogger((SDSCategory)USCategory.AUDIT).debug("unable to create manual task. No callback data");
            }
            this.callMonitorService(eventID, header);
        } else {
            SDSLogger.getLogger((SDSCategory)USCategory.AUDIT).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_US_CREATE_MANUAL_TASK);
            SDSLogger.getLogger((SDSCategory)USCategory.AUDIT).debug("unable to create manual task. No callback data");
        }
        this.handleNextRequest(context);
    }

    protected void callMonitorService(String eventID, BiBusHeader header) {
        if (eventID != null) {
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            String locale = headers.getUserPreferenceContentLocale();
            BiBusMonitorUtil.callMonitorServiceAddDependentMsg((BiBusHeader)header, (String)locale, (I18NCode)UsI18NCode.MSG_US_WAITING_FOR_TASK_COMPLETION, (String)eventID);
        }
    }
}

