/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.ws_ht.HandlerMapFactory;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.StringReader;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class CreateTaskPersistHandler
extends APIHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        HTSTask task = aContext.getPersistedTask();
        List<XmlObject> ops = HTSSDKUtils.getOperations(aContext.getApiObject(), task.getHtsTaskclass().getAddChildTaskOperationsAsArray());
        try {
            for (XmlObject op : ops) {
                String name = op.newCursor().getName().getLocalPart();
                IAPIHandler handler = HandlerMapFactory.getHandlerMap().getHandler(name);
                if (handler == null) {
                    throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_OPERATION_NAME, new Object[]{name});
                }
                BIBusEnvelope env = aContext.getRequest();
                env.getBody().selectSingleNode("./*").detach();
                SAXReader reader = new SAXReader();
                XmlOptions opts = new XmlOptions();
                opts.setSaveOuter();
                InputSource src = new InputSource(new StringReader(op.xmlText(opts)));
                Document doc = reader.read(src);
                Element docEl = doc != null ? doc.getRootElement() : null;
                if (docEl == null) continue;
                env.getBody().add(docEl);
                IAbstractContext opContext = handler.makeContext(aContext.getRequest());
                handler.handleRequest(opContext);
                aContext.addChildTaskCreateContext(opContext);
            }
        }
        catch (DocumentException e) {
            Utils.throwHumanTaskServiceException(e);
        }
        this.handleNextRequest(aContext);
    }
}

