/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Credential;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;

public class GenerateTcHandler
extends APIHandler
implements IAPIHandler {
    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        Credential credential = null;
        BiBusHeader header = context.getHeader().getBiBusHeader();
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        try {
            credential = AuthenticatorFactory.getInstance().getCredential(headers.getBiBusHeader());
        }
        catch (SDKClientException e) {
            this.debugLog(context, (Exception)((Object)e));
        }
        catch (EMFSecurityException e) {
            this.debugLog(context, (Exception)((Object)e));
        }
        if (credential == null) {
            try {
                AuthenticatorFactory.getInstance().generateTC(header);
            }
            catch (EMFSecurityException e) {
                Utils.logException(e);
            }
        }
        this.handleNextRequest(context);
    }

    private void debugLog(IAbstractContext context, Exception e) {
        String userToken = null;
        try {
            userToken = context.getUsTaskUser().getUserToken();
        }
        catch (HumanTaskServiceException e1) {
            Utils.debug(e.getLocalizedMessage());
        }
        Utils.debug("HTS AuthenticationHandler attempt to get credentials failed for user: " + userToken + " Exception is: " + e.getLocalizedMessage() + " Will attempt to generate credentials.");
    }
}

