/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandlerWrapper;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Date;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;

public class RetryHandler
extends APIHandler
implements IAPIHandlerWrapper {
    private static final ThreadLocal<String> retrying = new ThreadLocal();
    private static final String ME_KEY = "RETRY_HANDLER_KEY";
    private boolean DEBUG = false;
    private static int DEFAULT_TRANSACTION_MAX_RETRIES = 3;
    private SDSCategory m_logCategory = USCategory.RUNTIME;
    private int m_transactionMaxRetries = CRNProperties.getInstance().getIntProperty("transaction.max.retries", DEFAULT_TRANSACTION_MAX_RETRIES);
    private IAPIHandler handlerToExecute;

    public RetryHandler(IAPIHandler handlerToExecute) {
        if (this.m_transactionMaxRetries < 1) {
            this.m_transactionMaxRetries = DEFAULT_TRANSACTION_MAX_RETRIES;
        }
        this.handlerToExecute = handlerToExecute;
    }

    @Override
    public IAPIHandler getWrappedHandler() {
        return this.handlerToExecute;
    }

    private IAPIHandler getLeafHandler() {
        IAPIHandler leaf = this.getWrappedHandler();
        while (leaf instanceof IAPIHandlerWrapper) {
            leaf = ((IAPIHandlerWrapper)leaf).getWrappedHandler();
        }
        return leaf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        if (retrying.get() != null) {
            this.getLeafHandler().handleRequest(context);
            this.handleNextRequest(context);
            return;
        }
        retrying.set(ME_KEY);
        boolean retryTransaction = true;
        int transactionTries = 0;
        try {
            while (retryTransaction) {
                ++transactionTries;
                try {
                    if (transactionTries == 2 && context.getPersistedTask() != null) {
                        TaskDAO tDao = DAOFactory.getFactory().buildTaskDAO();
                        if (tDao.isDetached(context.getPersistedTask())) {
                            tDao.merge(context.getPersistedTask());
                        } else {
                            tDao.refresh(context.getPersistedTask());
                        }
                    }
                    this.handlerToExecute.handleRequest(context);
                    retryTransaction = false;
                    if (transactionTries <= 1) continue;
                    this.debugLog("Transaction succeeded at retry " + (transactionTries - 1));
                }
                catch (Throwable t) {
                    this.debugLog(new Date() + "Error executing a transaction!");
                    this.debugLog(t);
                    this.checkRetryTransaction(t, transactionTries);
                }
            }
        }
        finally {
            retrying.set(null);
        }
        this.handleNextRequest(context);
    }

    @Override
    public IAbstractContext makeContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        return this.handlerToExecute.makeContext(requestEnvelope);
    }

    private void debugLog(Throwable e) {
        SDSLogger.getLogger((SDSCategory)this.m_logCategory).debug(e);
        if (this.DEBUG) {
            try {
                FileWriter fw = new FileWriter("../logs/SQLTransactionExecutionHandler.log", true);
                PrintWriter pw = new PrintWriter(fw);
                pw.write("Exception is: " + e.getClass().getName());
                pw.println();
                pw.write(e.getMessage() != null ? e.getMessage() : "");
                pw.println();
                e.printStackTrace(pw);
                pw.println();
                pw.flush();
                pw.close();
            }
            catch (IOException e1) {
                System.out.println(e1);
            }
        }
    }

    private void debugLog(String message) {
        SDSLogger.getLogger((SDSCategory)this.m_logCategory).debug(message);
        if (this.DEBUG) {
            try {
                FileWriter fw = new FileWriter("../logs/SQLTransactionExecutionHandler.log", true);
                PrintWriter pw = new PrintWriter(fw);
                pw.write(message);
                pw.println();
                pw.flush();
                pw.close();
            }
            catch (IOException e1) {
                System.out.println(e1);
            }
        }
    }

    private void checkRetryTransaction(Throwable e, int transactionTries) throws HumanTaskServiceException {
        if (this.isDeadlockException(e) && transactionTries <= this.m_transactionMaxRetries) {
            int sleepTime = (int)(Math.random() * 1000.0);
            this.debugLog("Will retry transaction in " + sleepTime + " [milliseconds]. This will be retry " + transactionTries);
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        } else if (transactionTries > this.m_transactionMaxRetries) {
            this.debugLog("Transaction max retries exceeded! [max=" + this.m_transactionMaxRetries + "]");
            Utils.throwHumanTaskServiceException(e);
        } else {
            Utils.throwHumanTaskServiceException(e);
        }
    }

    private boolean isDeadlockException(Throwable e) {
        boolean isDeadlockException = false;
        while (e instanceof HumanTaskServiceException) {
            e = ((HumanTaskServiceException)((Object)e)).getNested();
        }
        if (e instanceof SQLException) {
            isDeadlockException = true;
        } else if (e instanceof PersistenceException) {
            isDeadlockException = true;
        } else if (e instanceof org.apache.openjpa.persistence.RollbackException || e instanceof RollbackException) {
            isDeadlockException = true;
        }
        return isDeadlockException;
    }
}

