/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandlerWrapper;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.DummyTransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.pojo.PojoCache;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;

public class TransactionHandler
extends APIHandler
implements IAPIHandlerWrapper {
    private IAPIHandler wrappedHandler;
    private TStatus.Enum statusOnFail = null;

    public TransactionHandler(IAPIHandler handler) {
        this.wrappedHandler = handler;
    }

    public TransactionHandler(IAPIHandler handler, TStatus.Enum statusOnFail) {
        this.wrappedHandler = handler;
        this.statusOnFail = statusOnFail;
    }

    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        ITransactionHandler tHandler = context.getTransactionHandler();
        try {
            context.setTransactionHandler(new DummyTransactionHandler(context.getTransactionHandler()));
            tHandler.beginTransaction();
            this.wrappedHandler.handleRequest(context);
            tHandler.commitTransaction();
        }
        catch (Throwable t) {
            PojoCache.clear();
            tHandler.rollbackTransaction();
            Utils.logException(t);
            if (t instanceof HumanTaskServiceException) {
                throw (HumanTaskServiceException)((Object)t);
            }
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, t);
        }
        finally {
            if (tHandler != null && !(tHandler instanceof DummyTransactionHandler)) {
                context.setTransactionHandler(tHandler);
            }
        }
    }

    @Override
    public IAPIHandler getWrappedHandler() {
        return this.wrappedHandler;
    }

    @Override
    public IAbstractContext makeContext(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        return this.wrappedHandler.makeContext(requestEnvelope);
    }
}

