/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupport;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.TaskuserDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;

public class UserDisplayNameStoreHandler
extends APIHandler
implements IAPIHandler {
    private HTSTaskUser user;
    private String displayName;
    private TaskuserDAO taskUserDao = DAOFactory.getFactory().buildTaskuserDAO();

    public UserDisplayNameStoreHandler(HTSTaskUser user) {
        this.user = user;
    }

    @Override
    protected void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        this.displayName = this.user.getDisplayName(context.getLocale());
        if (this.displayName == null) {
            try {
                String group = this.user.getLogicalPeopleGroup().toUpperCase();
                LogicalPeopleGroupSupport support = UserUtils.instance().getPeopleGroupSupport(group, context.getHeader().getBiBusHeader());
                this.displayName = support.getDisplayName(this.user.getUserToken(), context.getLocale());
            }
            catch (Exception e) {
                Utils.throwHumanTaskServiceException(e);
            }
            ITransactionHandler tx = AbstractContext.getCurrentTransactionHandler();
            tx.beginTransaction();
            try {
                this.user.setDisplayName(this.displayName, context.getLocale());
                this.taskUserDao.save(this.user);
                tx.commitTransaction();
            }
            catch (Throwable e) {
                tx.rollbackTransaction();
                Utils.throwHumanTaskServiceException(e);
            }
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

