/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.genHandlers;

import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.TaskuserDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.LPGUserKey;
import java.util.List;
import java.util.Map;

public class UserStoreHandler
extends APIHandler
implements IAPIHandler {
    private Map<LPGUserKey, HTSTaskUser> cachedUsers;
    private List<HTSTaskUser> newUsers;
    private TaskuserDAO taskUserDao = DAOFactory.getFactory().buildTaskuserDAO();

    public UserStoreHandler(List<HTSTaskUser> newUsers, Map<LPGUserKey, HTSTaskUser> cachedUsers) {
        this.newUsers = newUsers;
        this.cachedUsers = cachedUsers;
    }

    @Override
    protected void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        List<HTSTaskUser> existing = this.taskUserDao.findByUser(this.newUsers);
        for (HTSTaskUser hTSTaskUser : existing) {
            this.cachedUsers.put(hTSTaskUser.getLPGUserKey(), hTSTaskUser);
        }
        ITransactionHandler tx = AbstractContext.getCurrentTransactionHandler();
        tx.beginTransaction();
        try {
            for (HTSTaskUser newUser : this.newUsers) {
                if (existing.contains(newUser)) continue;
                newUser.setId(GuidUtils.create());
                this.taskUserDao.save(newUser);
                this.cachedUsers.put(newUser.getLPGUserKey(), newUser);
            }
            tx.commitTransaction();
        }
        catch (RuntimeException runtimeException) {
            this.cachedUsers.clear();
            tx.rollbackTransaction();
            throw runtimeException;
        }
    }
}

