/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.logging;

import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.LogOperations;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceOperations;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.CommentUtil;
import com.ibm.cognos.internal.hts.util.dao.builder.AuditBuilder;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.AuditMessageDocument;
import java.util.HashMap;
import java.util.Map;

public class AuditLogHandler
extends APIHandler
implements HumanTaskServiceOperations {
    private static Map<String, UsI18NCode> I18N_CODE_MAP = new HashMap<String, UsI18NCode>();

    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        String operation = context.getOperationName();
        int level = LogOperations.getAuditLevel(operation);
        UsI18NCode code = I18N_CODE_MAP.get(operation);
        if (level != -1 && code != null) {
            AuditMessageDocument audit = this.getAuditMessageDocument(code, level);
            this.insertAudit(context, audit);
        }
        this.handleNextRequest(context);
    }

    public AuditMessageDocument getAuditMessageDocument(UsI18NCode msg, int level) throws HumanTaskServiceException {
        AuditMessageDocument audit = AuditMessageDocument.Factory.newInstance();
        audit.addNewAuditMessage().setI18Ncode(msg.getCode());
        audit.getAuditMessage().setLevel(level);
        return audit;
    }

    public void insertAudit(IAbstractContext context, AuditMessageDocument audit) throws HumanTaskServiceException {
        HTSTask task = context.getPersistedTask();
        AuditBuilder builder = new AuditBuilder(audit, task, UserUtils.instance().getUser(context.getHeader()));
        CommentUtil.insertComment(context, builder);
    }

    static {
        I18N_CODE_MAP.put("complete", UsI18NCode.MSG_US_COMPLETE_MANUAL_TASK);
        I18N_CODE_MAP.put("claim", UsI18NCode.MSG_US_CLAIM);
        I18N_CODE_MAP.put("createAcknowledgeManualTask", UsI18NCode.MSG_US_CREATE_MANUAL_TASK);
        I18N_CODE_MAP.put("createAgentUserTask", UsI18NCode.MSG_US_CREATE_MANUAL_TASK);
        I18N_CODE_MAP.put("createApproveManualTask", UsI18NCode.MSG_US_CREATE_MANUAL_TASK);
        I18N_CODE_MAP.put("createNotificationManualTask", UsI18NCode.MSG_US_CREATE_MANUAL_TASK);
        I18N_CODE_MAP.put("createPushNotificationTask", UsI18NCode.MSG_US_CREATE_PUSH_NOTIFICATION_TASK);
        I18N_CODE_MAP.put("createGenericManualTask", UsI18NCode.CREATE_GENERIC_MANUAL_TASK);
        I18N_CODE_MAP.put("fail", UsI18NCode.MSG_US_FAIL);
        I18N_CODE_MAP.put("exit", UsI18NCode.MSG_US_EXIT);
        I18N_CODE_MAP.put("skip", UsI18NCode.MSG_US_SKIP);
        I18N_CODE_MAP.put("reassign", UsI18NCode.MSG_US_REASSIGN);
        I18N_CODE_MAP.put("setPriority", UsI18NCode.MSG_US_SET_PRIORITY);
        I18N_CODE_MAP.put("start", UsI18NCode.MSG_US_START);
        I18N_CODE_MAP.put("stop", UsI18NCode.MSG_US_STOP);
        I18N_CODE_MAP.put("completeNotification", UsI18NCode.MSG_US_COMPLETE_NOTIFICATION_TASK);
    }
}

