/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.notification;

import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.GenericOptionString;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.MemoOptionsBuilder;
import com.cognos.jsmcommon.util.OptionUtils;
import com.ibm.cognos.internal.hts._1.PushNotificationTask;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.CreatePushNotificatonMessageContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupport;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupportFactory;
import com.ibm.cognos.internal.hts.notification.DLSCaller;
import com.ibm.cognos.internal.hts.notification.DLSCallerFactory;
import com.ibm.cognos.internal.hts.notification.NotificationDetails;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.builder.PresentationElementsBuilder;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TFrom;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TGrouplist;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;

public class CreatePushNotificationMessageHandler
extends APIHandler {
    private void buildSubjectAndBody(CreatePushNotificatonMessageContext createPushNotificatonMessageContext, MemoOptionsBuilder memoBuilder, NotificationDetails notificationDetails) throws HumanTaskServiceException {
        PresentationElementsBuilder presElementsBuilder = null;
        HTSTaskclass tClass = createPushNotificatonMessageContext.getTaskClass();
        HTSTask task = createPushNotificatonMessageContext.getPersistedTask();
        presElementsBuilder = createPushNotificatonMessageContext.getEmailMessage() != null ? new PresentationElementsBuilder(createPushNotificatonMessageContext.getEmailMessage(), task, tClass, createPushNotificatonMessageContext) : new PresentationElementsBuilder(task, tClass, createPushNotificatonMessageContext);
        Locale defaultTaskLocale = createPushNotificatonMessageContext.getDefaultTaskLocale();
        String subject = presElementsBuilder.getSubject(defaultTaskLocale.getLanguage());
        notificationDetails.setSubject(subject);
        String msgBodyPlain = presElementsBuilder.getDescription("text/plain", defaultTaskLocale.getLanguage());
        String msgBodyHTML = presElementsBuilder.getDescription("text/html", defaultTaskLocale.getLanguage());
        notificationDetails.setMsgBodyPlain(msgBodyPlain);
        notificationDetails.setMsgBodyHTML(msgBodyHTML);
        memoBuilder.addBody(subject, msgBodyPlain, msgBodyHTML);
    }

    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        NotificationDetails notificationDetails = new NotificationDetails();
        CreatePushNotificatonMessageContext createPushNotificatonMessageContext = (CreatePushNotificatonMessageContext)context;
        ArrayList<String> addedRecipientsList = new ArrayList<String>();
        MemoOptionsBuilder memoBuilder = new MemoOptionsBuilder();
        TPeopleAssignments[] roles = createPushNotificatonMessageContext.getPeopleAssignments();
        this.addTo(this.getRecipients(roles), memoBuilder, addedRecipientsList);
        this.addCc(this.getStakeholders(roles), memoBuilder, addedRecipientsList);
        notificationDetails.setRecipientsList(addedRecipientsList);
        int recipientCount = addedRecipientsList.size();
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("CreatePushNotificationMessageHandler recipientCount:" + recipientCount + ", addedRecipientsList:" + addedRecipientsList);
        if (recipientCount > 0) {
            this.buildSubjectAndBody(createPushNotificatonMessageContext, memoBuilder, notificationDetails);
            if (context instanceof CreatePushNotificatonMessageContext) {
                CreatePushNotificatonMessageContext createPushNotificatonMsgContext = (CreatePushNotificatonMessageContext)context;
                createPushNotificatonMsgContext.setNotificationDetails(notificationDetails);
            }
            GenericOptionString genericOption = null;
            try {
                CreatePushNotificatonMessageContext createPushNotificatonMsgContext;
                PushNotificationTask pushNotificationTask;
                genericOption = new GenericOptionString();
                genericOption.setName("pushNotificationAdditionalData");
                if (context instanceof CreatePushNotificatonMessageContext && (pushNotificationTask = (createPushNotificatonMsgContext = (CreatePushNotificatonMessageContext)context).getPushNotificationTask()) != null) {
                    genericOption.setValue(pushNotificationTask.getAdditionalData());
                }
            }
            catch (Exception ex) {
                Utils.debug("Error while generating generic option for push notification additional data for DLS call");
                Utils.logException(ex);
            }
            try {
                DeliveryOption[] options = memoBuilder.getOptionsArray();
                if (genericOption != null) {
                    options = OptionUtils.mergeOptions((Option[])new Option[]{genericOption}, (Option[])options);
                }
                DLSCaller caller = DLSCallerFactory.getCaller();
                caller.run(context, (Option[])options);
            }
            catch (Exception e) {
                Utils.throwHumanTaskServiceException(e);
            }
        }
        this.handleNextRequest(context);
    }

    private TGenericHumanRole[] getRecipients(TPeopleAssignments[] assignments) {
        ArrayList<TGenericHumanRole> recipients = new ArrayList<TGenericHumanRole>();
        for (int i = 0; i < assignments.length; ++i) {
            recipients.addAll(Arrays.asList(assignments[i].getRecipientsArray()));
        }
        return recipients.toArray(new TGenericHumanRole[0]);
    }

    private TGenericHumanRole[] getStakeholders(TPeopleAssignments[] assignments) {
        ArrayList<TGenericHumanRole> recipients = new ArrayList<TGenericHumanRole>();
        for (int i = 0; i < assignments.length; ++i) {
            recipients.addAll(Arrays.asList(assignments[i].getTaskStakeholdersArray()));
        }
        return recipients.toArray(new TGenericHumanRole[0]);
    }

    private void addTo(TGenericHumanRole[] roles, MemoOptionsBuilder memoBuilder, List<String> addedRecipientsList) throws HumanTaskServiceException {
        for (int i = 0; i < roles.length; ++i) {
            this.addRecipients(roles[i], DeliveryOptionEnum.to, memoBuilder, addedRecipientsList);
        }
    }

    private void addCc(TGenericHumanRole[] roles, MemoOptionsBuilder memoBuilder, List<String> addedRecipientsList) throws HumanTaskServiceException {
        for (int i = 0; i < roles.length; ++i) {
            this.addRecipients(roles[i], DeliveryOptionEnum.cc, memoBuilder, addedRecipientsList);
        }
    }

    private void addRecipients(TGenericHumanRole role, DeliveryOptionEnum addressStyle, MemoOptionsBuilder memoBuilder, List<String> addedRecipientsList) throws HumanTaskServiceException {
        try {
            int j;
            OrganizationalEntityDocument oed;
            TOrganizationalEntity oe;
            TFrom from = role.getFrom();
            QName logicalPeopleGroup = from.getLogicalPeopleGroup();
            if (logicalPeopleGroup != null) {
                LogicalPeopleGroupSupport lpgSupport = LogicalPeopleGroupSupportFactory.getInstance().getLogicalPeopleGroupSupport(logicalPeopleGroup.getLocalPart().toUpperCase());
                addressStyle = lpgSupport.getAddressStyle(addressStyle);
            }
            TUserlist users = (oe = (oed = HTSSDKUtils.getOrganizationalEntity(from.getLiteral())).getOrganizationalEntity()).sizeOfUsersArray() != 0 ? oe.getUsersArray(0) : null;
            TGrouplist groups = oe.sizeOfGroupsArray() != 0 ? oe.getGroupsArray(0) : null;
            String address = "";
            for (j = 0; users != null && j < users.sizeOfUserArray(); ++j) {
                address = users.getUserArray(j);
                memoBuilder.addAddress(address, addressStyle);
                addedRecipientsList.add(address);
                address = "";
            }
            for (j = 0; groups != null && j < groups.sizeOfGroupArray(); ++j) {
                address = groups.getGroupArray(j);
                memoBuilder.addAddress(address, addressStyle);
                addedRecipientsList.add(address);
                address = "";
            }
        }
        catch (Exception ex) {
            Utils.throwHumanTaskServiceException(ex);
        }
    }
}

