/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.notification;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.deadline.DeadlineRunContext;
import com.ibm.cognos.internal.hts.apiHandlers.notification.NotificationHandler;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSEscalation;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import java.util.List;

public class DeadlineEscalationNotificationHandler
extends NotificationHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        if (!(context instanceof DeadlineRunContext)) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR);
        }
        this.checkTaskForInputMessage(context);
        BiBusHeader header = null;
        try {
            header = UserUtils.instance().logon(context.getPersistedTask().getCreatedBy());
            if (header != null) {
                context.getHeader().setBiBusHeader(header);
                HTSDeadline dl = ((DeadlineRunContext)context).getUsDeadline();
                List<HTSEscalation> escalations = dl.getEscalations();
                if (escalations != null && escalations.size() > 0) {
                    for (HTSEscalation hTSEscalation : escalations) {
                        this.processEscalation(context, hTSEscalation);
                    }
                }
            } else {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_USV_DEADLINES_FAILED, new Object[]{context.getPersistedTask().getId()});
            }
        }
        finally {
            if (header != null) {
                UserUtils.instance().logoff(header);
            }
        }
        this.handleNextRequest(context);
    }

    private void checkTaskForInputMessage(IAbstractContext context) {
        HTSTask task = context.getPersistedTask();
        if (task == null || task.getHtsMessages() == null) {
            TaskDAO taskDao = DAOFactory.getFactory().buildTaskDAO();
            task = (HTSTask)taskDao.getById(task.getId());
            context.setPersistedTask(task);
        }
    }
}

