/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.notification;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.notification.LocalNotificationContextBuilder;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSEscalation;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSEscalationHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSLocalNotification;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskOverrides;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceOperations;
import com.ibm.cognos.internal.hts.service.ws_ht.HandlerMapFactory;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.humanrole.EscalationHumanRoleOrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import com.ibm.cognos.internal.hts.xpath.XPathEvaluator;
import com.ibm.cognos.internal.hts.xpath.XPathVariableContext;
import java.util.List;
import org.dom4j.Node;

public abstract class NotificationHandler
extends APIHandler
implements HumanTaskServiceOperations {
    protected HTSTaskclass getLocalNotificationClass(String localNotificationName) {
        HTSTaskclass taskClass = AbstractContext.getPojoCache().getLatestTaskClassByName(localNotificationName);
        return taskClass;
    }

    protected void processEscalation(IAbstractContext context, HTSEscalation hTSEscalation) throws HumanTaskServiceException {
        String condition = hTSEscalation.getConditionExpression();
        boolean conditionEvaluation = this.evaluateCondition(context, condition);
        HTSLocalNotification localNotification = hTSEscalation.getHtsLocalNotification();
        if (conditionEvaluation && localNotification != null) {
            String localNote = localNotification.getLocalNotification();
            List<HTSEscalationHumanRole> schrs = hTSEscalation.getHtsLocalNotification().getHtsEscalationHumanRoles();
            this.fireLocalNotificationTask(context, localNote, schrs);
        }
    }

    private void fireLocalNotificationTask(IAbstractContext context, String ref, List<HTSEscalationHumanRole> humanRoles) {
        try {
            HTSTaskclass localNotificationTaskClass = this.getLocalNotificationClass(ref);
            if (localNotificationTaskClass == null) {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_US_NO_LOCAL_NOTIFICATION_REF_FOUND, new Object[]{ref});
                return;
            }
            String localNotificationCreateOperation = localNotificationTaskClass.getOperation();
            IAPIHandler localNotificationHandler = HandlerMapFactory.getHandlerMap().getHandler(localNotificationCreateOperation);
            AbstractContext localNotificationContext = LocalNotificationContextBuilder.makeContext(context, localNotificationHandler, localNotificationCreateOperation);
            HTSTaskOverrides overrides = new HTSTaskOverrides();
            overrides.setStateChangeHumanRoles(this.getPeopleAssignments(context, humanRoles));
            overrides.setTaskMessageId(context.getPersistedTask().getId());
            overrides.setTaskclass(localNotificationTaskClass);
            localNotificationContext.setOverrides(overrides);
            localNotificationContext.getHeader().setBiBusHeader(context.getHeader().getBiBusHeader());
            if (overrides.hasRecipients()) {
                localNotificationHandler.handleRequest(localNotificationContext);
            }
        }
        catch (Throwable e) {
            Utils.logException(e);
        }
    }

    private TPeopleAssignments[] getPeopleAssignments(IAbstractContext context, List<HTSEscalationHumanRole> humanRoles) throws HumanTaskServiceException {
        EscalationHumanRoleOrganizationalEntityConverter converter = new EscalationHumanRoleOrganizationalEntityConverter(context);
        TPeopleAssignments peopleAssignments = converter.getPeopleAssignments(humanRoles).getPeopleAssignments();
        return new TPeopleAssignments[]{peopleAssignments};
    }

    private boolean evaluateCondition(IAbstractContext context, String condition) throws HumanTaskServiceException {
        if (condition == null || condition.trim().equals("")) {
            return true;
        }
        XPathVariableContext vc = new XPathVariableContext();
        vc.setVariableValue(XPathVariableContext.XPathVariable.CONTEXT, context);
        XPathEvaluator evaluator = new XPathEvaluator(vc);
        boolean evaluationResult = true;
        Object resultObject = evaluator.selectNode(condition);
        if (resultObject instanceof Node) {
            String text = ((Node)resultObject).getText();
            evaluationResult = Boolean.valueOf(text);
        } else if (resultObject instanceof String || resultObject instanceof Boolean) {
            evaluationResult = Boolean.valueOf(resultObject.toString());
        }
        return evaluationResult;
    }
}

