/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.ActivateHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.ActivateContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.Date;
import java.util.List;

public class ActivatePersistHandler
extends ActivateHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        ActivateContext context = (ActivateContext)aContext;
        HTSTask task = context.getPersistedTask();
        Date activationDate = new Date(task.getActivationTime() == null ? 0L : task.getActivationTime());
        if (activationDate.after(new Date())) {
            Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_CANNOT_ACTIVATE, new Object[]{task.getName(), activationDate});
        }
        List<HTSHumanRole> potOwners = task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS);
        TStatus.Enum targetStatus = context.getStatusManagement().getFinalStatus(task);
        if (targetStatus.equals(TStatus.RESERVED)) {
            HTSTaskUser user = potOwners.get(0).getHtsTaskUser();
            String newUser = user.getUserToken();
            String currentUser = task.getActualOwner() != null ? task.getActualOwner().getUserToken() : "";
            task.setActualOwner(user);
            boolean userChanged = newUser != null && currentUser != null ? newUser.equals(currentUser) : false;
            context.setOwnerChanged(userChanged);
        }
        task.setStatus(targetStatus.toString());
        this.handleNextRequest(context);
    }
}

