/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.AssignFolderToTasksHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AssignFolderToTaskContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.FolderDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSFolder;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskReadBy;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSUnSubscription;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.StateManagement;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventState;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AssignFolderToTasksPersistHandler
extends AssignFolderToTasksHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        AssignFolderToTaskContext context = (AssignFolderToTaskContext)aContext;
        List<HTSFolder> toAdd = context.getAddFolders();
        List<HTSFolder> toRemove = context.getRemoveFolders();
        FolderDAO folderDao = DAOFactory.getFactory().buildFolderDAO();
        for (HTSFolder folder : toAdd) {
            folderDao.save(folder);
            this.tidyUpDeletedTask(context, folder);
        }
        for (HTSFolder folder : toRemove) {
            HTSTask task = folder.getHtsTask();
            task.removeFolder(folder);
        }
        this.handleNextRequest(context);
    }

    private void tidyUpDeletedTask(AssignFolderToTaskContext context, HTSFolder folder) throws HumanTaskServiceException {
        if (folder.getFolderName().equals("DELETED")) {
            HTSTask task = folder.getHtsTask();
            if (context.getUsTaskUser().equals(task.getActualOwner())) {
                StateManagement sm = new StateManagement("assignFolderToTasks", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, TStatus.Enum.forString((String)task.getStatus()), task.getTaskType(), HTSTaskReadBy.READ_LEVEL.ACKNOWLEDGED);
                Iterator<HTSHumanRole> status = sm.getFinalStatus(task);
                if (status != null) {
                    task.setStatus(status.toString());
                }
                task.setActualOwner(null);
                context.setOwnerChanged(true);
            }
            ArrayList<HTSHumanRole> removedRoles = new ArrayList<HTSHumanRole>();
            for (HTSHumanRole humanRole : task.getHtsHumanRoles()) {
                if (!humanRole.getHtsTaskUser().equals(context.getUsTaskUser())) continue;
                removedRoles.add(humanRole);
            }
            for (HTSHumanRole humanRole2 : removedRoles) {
                task.removeHTSHumanrole(humanRole2);
            }
            if (task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS).size() == 1) {
                task.setActualOwner(task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS).get(0).getHtsTaskUser());
            }
            ArrayList<HTSUnSubscription> unsubscribers = new ArrayList<HTSUnSubscription>(task.getUnSubscriptions());
            HashMap<String, HTSUnSubscription> myUnsubscriptionsByEvent = new HashMap<String, HTSUnSubscription>();
            for (HTSUnSubscription unSubscription : unsubscribers) {
                if (!context.getUsTaskUser().equals(unSubscription.getUser())) continue;
                unSubscription.setSubscriptionState(SubscriptionEventState.INDIVIDUAL_UNSUBSCRIBE.toString());
                myUnsubscriptionsByEvent.put(unSubscription.getEvent(), unSubscription);
            }
            SubscriptionEventType.Enum[] types = new SubscriptionEventType.Enum[]{SubscriptionEventType.COMMENTS, SubscriptionEventType.COMPLETE_DEADLINE, SubscriptionEventType.NOTIFY_ON_CREATION, SubscriptionEventType.START_DEADLINE, SubscriptionEventType.STATE_CHANGE_COMPLETED, SubscriptionEventType.STATE_CHANGE_FAILED, SubscriptionEventType.STATE_CHANGE_CANCELLED, SubscriptionEventType.STATE_CHANGE_OWNER_CHANGED, SubscriptionEventType.STATE_CHANGE_STARTED, SubscriptionEventType.STATE_CHANGE_ON_HOLD};
            for (int i = 0; i < types.length; ++i) {
                if (myUnsubscriptionsByEvent.containsKey(types[i].toString())) continue;
                HTSUnSubscription unsubscription = new HTSUnSubscription();
                unsubscription.setId(GuidUtils.create());
                unsubscription.setEvent(types[i].toString());
                if (folder.getHtsTaskuser() == null) {
                    unsubscription.setSubscriptionState(SubscriptionEventState.GLOBAL_UNSUBSCRIBE.toString());
                } else {
                    unsubscription.setSubscriptionState(SubscriptionEventState.INDIVIDUAL_UNSUBSCRIBE.toString());
                    unsubscription.setUser(folder.getHtsTaskuser());
                }
                task.addUnSubscriber(unsubscription);
            }
        }
    }
}

