/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.CompleteHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.CompleteContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.event.EventDispatcher;
import com.ibm.cognos.internal.hts.event.TaskUpdateEvent;
import com.ibm.cognos.internal.hts.event.TaskUpdateStatus;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.MessageUtils;
import com.ibm.cognos.internal.hts.util.pojo.MESSAGE_TYPE;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.Date;

public class CompletePersistHandler
extends CompleteHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        CompleteContext context = (CompleteContext)aContext;
        HTSTask task = context.getPersistedTask();
        String oldStatus = task.getStatus();
        String output = context.getOutputData();
        MESSAGE_TYPE type = MESSAGE_TYPE.OUTPUT;
        if (output == null && context.getError() != null) {
            output = context.getError().getFaultMessage();
            type = MESSAGE_TYPE.FAULT;
        }
        if (output == null || "".equals(output)) {
            Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_NO_COMPLETION_DATA, new Object[]{task.getName()});
        }
        MessageUtils.createMessageInTask(task, output, null, type);
        task.setCompletedOn(new Date().getTime());
        TStatus.Enum newTStatus = context.getStatusManagement().getFinalStatus(task);
        context.setTargetStatus(newTStatus);
        String newStatus = newTStatus.toString();
        if (oldStatus != null && !oldStatus.equals(newStatus)) {
            TaskUpdateStatus taskUpdate = new TaskUpdateStatus(context, oldStatus, newStatus);
            TaskUpdateEvent event = new TaskUpdateEvent(this, taskUpdate);
            EventDispatcher.instance().fireEvent(event);
        }
        this.handleNextRequest(context);
    }
}

