/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.CreateManualTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.CreateManualTaskContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.dao.TaskUtil;
import com.ibm.cognos.internal.hts.util.dao.builder.TaskBuilder;
import java.util.Calendar;
import java.util.Date;

public class CreateManualTaskPersistHandler
extends CreateManualTaskHandler {
    private static long DEFAULT_EXPIRATION = 31536000000L;
    private static long DEFAULT_ACTIVATION = 60000L;

    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        CreateManualTaskContext context = (CreateManualTaskContext)aContext;
        Date now = new Date();
        TaskBuilder builder = new TaskBuilder();
        builder.setPerfData(context.getPerfData());
        builder.setActivationTime(this.getTime(context.getActivationTime(), new Date(now.getTime() - DEFAULT_ACTIVATION)));
        builder.setCreatedBy(context.getCreatedBy());
        builder.setCreatedOn(new Date().getTime());
        builder.setExpirationTime(this.getTime(context.getExpirationTime(), new Date(now.getTime() + DEFAULT_EXPIRATION)));
        builder.setTaskClass(context.getOperationName());
        builder.setMessage(context.getOperation().asXML());
        builder.setName(context.getName());
        builder.setPresentationElements(context.getPresentationElements());
        builder.setPriority(context.getPriority());
        builder.setRoles(context.getUsHumanroles());
        builder.setFolders(context.getAPIFolders(builder.getUsTask()));
        builder.setCallBack(context.getHeader(), builder.getUsTask().getId());
        builder.setDefaultLocale(context.getLocale().toString());
        HTSTask task = builder.buildTask();
        TaskUtil.persistTask(task);
        context.setPersistedTask(builder.getUsTask());
        this.handleNextRequest(context);
    }

    private long getTime(Calendar cal, Date defaultVal) {
        if (cal == null) {
            return defaultVal.getTime();
        }
        if (cal.getTime() == null) {
            return defaultVal.getTime();
        }
        return cal.getTime().getTime();
    }
}

