/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.DelegateHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.ChangedHumanRoleMode;
import com.ibm.cognos.internal.hts.apiHandlers.context.DelegateContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.dao.TaskUtil;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DelegatePersistHandler
extends DelegateHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        TStatus.Enum targetStatus;
        DelegateContext context = (DelegateContext)aContext;
        HTSTask task = context.getPersistedTask();
        HTSHumanRole delegatedToHumanRole = context.getUsHumanrole();
        List<HTSHumanRole> potentialOwnersList = task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS);
        int index = Collections.binarySearch(potentialOwnersList, delegatedToHumanRole, new Comparator<HTSHumanRole>(){

            @Override
            public int compare(HTSHumanRole o1, HTSHumanRole o2) {
                String token1 = o1.getHtsTaskUser().getUserToken();
                String token2 = o2.getHtsTaskUser().getUserToken();
                return token1.compareTo(token2);
            }
        });
        if (index < 0) {
            task.addHTSHumanRole(delegatedToHumanRole);
            context.addChangedHumanRole(ChangedHumanRoleMode.CHANGED_ROLE_TYPE_ADDED, delegatedToHumanRole);
        }
        if ((targetStatus = context.getStatusManagement().getFinalStatus(task)).equals(TStatus.RESERVED)) {
            task.setStatus(targetStatus.toString());
            HTSTaskUser user = delegatedToHumanRole.getHtsTaskUser();
            String newUser = user.getUserToken();
            String currentUser = task.getActualOwner() != null ? task.getActualOwner().getUserToken() : "";
            task.setActualOwner(user);
            boolean userChanged = !String.valueOf(newUser).equals(String.valueOf(currentUser));
            context.setOwnerChanged(userChanged);
        }
        TaskUtil.updateTask(task);
        this.handleNextRequest(context);
    }
}

