/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.CallbackparamDAO;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallback;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallbackParam;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.Date;
import java.util.List;
import org.dom4j.Element;

public class ExitPersistHandler
extends APIHandler {
    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        Element op = context.getOperation();
        String id = op.selectSingleNode("./*[local-name()='eventID']").getText();
        CallbackparamDAO dao = DAOFactory.getFactory().buildCallbackparamDAO();
        List<HTSCallbackParam> params = dao.findByValue(id);
        for (HTSCallbackParam callbackParam : params) {
            HTSCallback cb = callbackParam.getHtsCallback();
            HTSTask task = cb.getHtsTask();
            task.setStatus(TStatus.EXITED.toString());
            task.setCompletedOn(new Date().getTime());
            TaskDAO taskDAO = DAOFactory.getFactory().buildTaskDAO();
            taskDAO.save(task);
            context.setPersistedTask(task);
        }
        if (context.getPersistedTask() == null) {
            Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_EXIT, new Object[0]);
        }
        this.handleNextRequest(context);
    }
}

