/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.FailHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.FailContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.MessageUtils;
import com.ibm.cognos.internal.hts.util.pojo.MESSAGE_TYPE;
import java.util.Date;

public class FailPersistHandler
extends FailHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        FailContext context = (FailContext)aContext;
        HTSTask task = context.getPersistedTask();
        String fault = context.getFault();
        if (fault == null && context.getError() != null) {
            fault = context.getError().getFaultMessage();
        }
        if (fault == null || "".equals(fault)) {
            Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_NO_FAULT_DATA, new Object[]{task.getName()});
        }
        MessageUtils.createMessageInTask(task, context.getFault(), context.getFaultName(), MESSAGE_TYPE.FAULT);
        task.setCompletedOn(new Date().getTime());
        MessageUtils.save(task);
        context.setTargetStatus(context.getStatusManagement().getFinalStatus(task));
        this.handleNextRequest(context);
    }
}

