/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.ibm.cognos.internal.hts.apiHandlers.GetCommentInfoHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.GetCommentInfoContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPost;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSThread;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.AuditMessageDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.AuditParam;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.CommentType;
import java.util.List;
import java.util.Locale;
import org.apache.xmlbeans.XmlException;

public class GetCommentInfoPersistHandler
extends GetCommentInfoHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        GetCommentInfoContext context = (GetCommentInfoContext)aContext;
        HTSPost post = (HTSPost)DAOFactory.getFactory().buildUspostDAO().getById(context.getCommentId());
        HTSThread thread = post.getHtsThread();
        if (thread.getHtsPosts() != null && thread.getType().equals(CommentType.AUDIT.toString())) {
            post = this.processAuditComments(context, thread, post);
        }
        context.setPosts(thread.getHtsPosts());
        context.setPost(post);
        this.handleNextRequest(context);
    }

    private HTSPost processAuditComments(IAbstractContext context, HTSThread aThread, HTSPost onePost) throws HumanTaskServiceException {
        List<HTSPost> auditPosts = aThread.getHtsPosts();
        for (HTSPost post : auditPosts) {
            try {
                AuditMessageDocument audit = AuditMessageDocument.Factory.parse((String)post.getPagetext());
                String msgCode = audit.getAuditMessage().getI18Ncode();
                AuditParam[] auditParams = audit.getAuditMessage().getParamArray();
                Object[] params = new String[auditParams.length];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = auditParams[i].getStringValue();
                }
                String msg = I18NUtil.getMessage((I18NCode)new UsI18NCode(msgCode, "Client"), (Object[])params, (Locale)context.getLocale());
                post.setPagetext(msg);
                if (!post.equals(onePost)) continue;
                onePost = post;
            }
            catch (XmlException e) {
                Utils.throwHumanTaskServiceException(e);
            }
        }
        return onePost;
    }
}

