/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.ibm.cognos.internal.hts.apiHandlers.GetCommentsHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractCommentsContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.AuditLogUtil;
import com.ibm.cognos.internal.hts.persist.dao.PostComparator;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPost;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSThread;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.AuditMessageDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.AuditParam;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.CommentType;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.ParamType;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.xmlbeans.XmlException;

public class GetCommentsPersistHandler
extends GetCommentsHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        AbstractCommentsContext context = (AbstractCommentsContext)aContext;
        HTSTask task = context.getPersistedTask();
        List<HTSThread> threads = task.getHtsThreads();
        if (threads != null && threads.size() > 0) {
            for (HTSThread aThread : threads) {
                if (aThread.getHtsPosts() != null && aThread.getType().equals(CommentType.AUDIT.toString())) {
                    this.processAuditComments(context, aThread);
                }
                Collections.sort(aThread.getHtsPosts(), new PostComparator());
                context.addComments(aThread);
            }
        }
        this.handleNextRequest(context);
    }

    private void processAuditComments(AbstractCommentsContext context, HTSThread aThread) throws HumanTaskServiceException {
        List<HTSPost> auditPosts = aThread.getHtsPosts();
        for (HTSPost post : auditPosts) {
            try {
                AuditMessageDocument audit = AuditMessageDocument.Factory.parse((String)post.getPagetext());
                String msgCode = audit.getAuditMessage().getI18Ncode();
                AuditParam[] auditParams = audit.getAuditMessage().getParamArray();
                Object[] params = new Object[auditParams.length];
                for (int i = 0; i < params.length; ++i) {
                    ParamType.Enum type = auditParams[i].getType();
                    if (type == null || type.equals(ParamType.STRING)) {
                        params[i] = auditParams[i].getStringValue();
                        continue;
                    }
                    if (type.equals(ParamType.POST_USER_ID)) {
                        params[i] = post.getHtsTaskUser().getDisplayName(context.getLocale());
                        continue;
                    }
                    if (type.equals(ParamType.USER_ID)) {
                        HTSTaskUser user = UserUtils.instance().findUser(auditParams[i].getStringValue());
                        if (user != null) {
                            params[i] = UserUtils.instance().getUserName(context, user);
                            continue;
                        }
                        params[i] = AuditLogUtil.getI18NCode(AuditLogUtil.UNAVAILABLE);
                        continue;
                    }
                    if (type.equals(ParamType.LOCALIZABLE_STRING)) {
                        UsI18NCode code = AuditLogUtil.getI18NCode(auditParams[i].getStringValue());
                        if (code != null) {
                            params[i] = code;
                            continue;
                        }
                        params[i] = auditParams[i].getStringValue();
                        continue;
                    }
                    params[i] = type == null || type.equals(ParamType.DATE_LONG) ? TimeUtils.getUserTZFormattedTime(Long.valueOf(auditParams[i].getStringValue()), context, context.getLocale()) : auditParams[i].getStringValue();
                }
                String msg = I18NUtil.getMessage((I18NCode)new UsI18NCode(msgCode, "Client"), (Object[])params, (Locale)context.getLocale());
                post.setPagetext(msg);
            }
            catch (XmlException e) {
                Utils.throwHumanTaskServiceException(e);
            }
        }
    }
}

