/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.GetRenderingTypesHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.GetRenderingTypesContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRendering;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class GetRenderingTypesPersistHandler
extends GetRenderingTypesHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        GetRenderingTypesContext context = (GetRenderingTypesContext)aContext;
        List<HTSRendering> renderingsList = context.getPersistedTask().getHtsTaskclass().getHtsRenderings();
        if (renderingsList == null) {
            Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_ERROR_RETRIEVING_RENDERING_TYPES, new Object[0]);
        }
        context.setRenderingTypes(this.getRenderingTypesList(renderingsList));
        this.handleNextRequest(context);
    }

    private ArrayList<QName> getRenderingTypesList(List<HTSRendering> renderingsList) throws HumanTaskServiceException {
        ArrayList<QName> qNameList = new ArrayList<QName>();
        Iterator<HTSRendering> i = renderingsList.iterator();
        while (i.hasNext()) {
            qNameList.add(this.makeRenderingType(i.next()));
        }
        return qNameList;
    }

    private QName makeRenderingType(HTSRendering rendering) throws HumanTaskServiceException {
        if (rendering == null || rendering.getType() == null) {
            Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_ERROR_RETRIEVING_RENDERING_TYPES, new Object[0]);
        }
        String renderingType = rendering.getType();
        String prefix = "".equals(rendering.getTypePrefix()) ? null : rendering.getTypePrefix();
        String namespace = "".equals(rendering.getTypeNamespace()) ? null : rendering.getTypeNamespace();
        QName qname = null;
        qname = namespace != null && prefix != null ? new QName(namespace, renderingType, prefix) : (namespace != null ? new QName(namespace, renderingType) : new QName(renderingType));
        return qname;
    }
}

