/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AssignFolderToTaskContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.StateManagement;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.HumanroleUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.List;

public class GetValidFolderAssignationTasksHandler
extends APIHandler
implements IAPIHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        AssignFolderToTaskContext context = (AssignFolderToTaskContext)aContext;
        TaskDAO dao = DAOFactory.getFactory().buildTaskDAO();
        String[] ids = context.getTaskIds().getTaskIdArray();
        HTSTask persistedTask = null;
        for (int i = 0; i < ids.length; ++i) {
            try {
                persistedTask = (HTSTask)dao.getById(ids[i]);
                HTSTask.TYPE type = persistedTask.getTaskType();
                TStatus.Enum status = TStatus.Enum.forString((String)persistedTask.getStatus());
                List<HTSRole.Roles> roles = HumanroleUtils.getRoles(persistedTask, context);
                new StateManagement(context.getOperationName(), roles.toArray(new HTSRole.Roles[0]), status, type, null);
                context.addTask(persistedTask);
                continue;
            }
            catch (HumanTaskServiceException hte) {
                throw hte;
            }
            catch (Throwable t) {
                Utils.throwHumanTaskServiceException(t, UsI18NCode.MSG_US_INVALID_PARAMETER, new Object[]{"ID", aContext.getOperationName(), aContext.getTaskId()});
            }
        }
        this.handleNextRequest(aContext);
    }
}

