/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.internal.hts.apiHandlers.QueryHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.QueryContext;
import com.ibm.cognos.internal.hts.persist.dao.Criteria;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.types.TaskQuery;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.dao.TaskUtil;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.List;

public class QueryPersistHandler
extends QueryHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"HTS: InboxTaskListFetchTime");
        QueryContext context = (QueryContext)aContext;
        TaskQuery type = TaskQuery.ALL;
        TaskDAO dao = DAOFactory.getFactory().buildTaskDAO();
        Criteria criteria = dao.buildCriteria();
        criteria.getSelectClause().parseSelectClause(context.getSelectClause());
        criteria.getWhereClause().parseWhereClause(context.getWhereClause());
        criteria.getOrderByClause().parseOrderByClause(context.getOrderByClause());
        int myInboxListSize = TaskUtil.getMyInboxListSize(context);
        if (myInboxListSize > 0) {
            criteria.setMaxReturnCount(myInboxListSize);
        } else {
            criteria.setMaxReturnCount(context.getMaxTasks());
        }
        criteria.setReturnOffset(context.getTaskIndexOffset());
        List<HTSTask> taskList = null;
        taskList = context.isSearchForCMReference() ? TaskUtil.getMyTasksForCm(type, context, criteria) : TaskUtil.getMyRoleTasks(type, (IAbstractContext)context, criteria);
        context.setTasksList(taskList);
        zipiTimer.stop();
        this.handleNextRequest(context);
    }
}

