/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.ReassignHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.ReassignContext;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.dao.HumanroleUtils;
import com.ibm.cognos.internal.hts.util.dao.TaskUtil;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.ArrayList;

public class ReassignPersistHandler
extends ReassignHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        ReassignContext context = (ReassignContext)aContext;
        HTSTask task = context.getPersistedTask();
        ArrayList<HTSHumanRole> newOwners = context.getUsHumanroles();
        for (HTSHumanRole humanrole : newOwners) {
            humanrole.setId(GuidUtils.create());
        }
        HumanroleUtils.updateHumanRoles(context, task, newOwners, HTSRole.Roles.POTENTIAL_OWNERS);
        TStatus.Enum targetStatus = context.getStatusManagement().getFinalStatus(task);
        task.setActualOwner(null);
        if (targetStatus.equals(TStatus.RESERVED)) {
            HTSTaskUser user = newOwners.get(0).getHtsTaskUser();
            String newUser = user.getUserToken();
            String currentUser = task.getActualOwner() != null ? task.getActualOwner().getUserToken() : "";
            task.setActualOwner(user);
            boolean userChanged = !String.valueOf(newUser).equals(String.valueOf(currentUser));
            context.setOwnerChanged(userChanged);
        } else {
            context.setOwnerChanged(true);
        }
        task.setStatus(targetStatus.toString());
        TaskUtil.updateTask(task);
        this.handleNextRequest(context);
    }
}

