/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.RemoveHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.RemoveContext;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.HumanroleDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class RemovePersistHandler
extends RemoveHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        RemoveContext context = (RemoveContext)aContext;
        HTSTask task = context.getPersistedTask();
        HTSTaskUser user = UserUtils.instance().getUser(context.getHeader());
        List<HTSHumanRole> notificationRecipients = task.getHumanroles(HTSRole.Roles.NOTIFICATION_RECIPIENTS);
        HTSHumanRole toBeRemoved = null;
        Iterator<HTSHumanRole> iterator = notificationRecipients.iterator();
        while (iterator.hasNext() && toBeRemoved == null) {
            HTSHumanRole humanrole = iterator.next();
            if (!humanrole.getHtsTaskUser().equals(user)) continue;
            toBeRemoved = humanrole;
        }
        if (toBeRemoved != null) {
            task.removeHTSHumanrole(toBeRemoved);
            HumanroleDAO hDao = DAOFactory.getFactory().buildHumanroleDAO();
            hDao.delete(toBeRemoved);
            notificationRecipients = task.getHumanroles(HTSRole.Roles.NOTIFICATION_RECIPIENTS);
            if (notificationRecipients.isEmpty()) {
                task.setStatus(TStatus.COMPLETED.toString());
                task.setCompletedOn(new Date().getTime());
            }
        }
        this.handleNextRequest(context);
    }
}

