/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.ibm.cognos.internal.hts.apiHandlers.ClaimHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.ReopenContext;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadlineInstance;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.dao.builder.DeadlineInstanceBuilder;
import java.util.Date;
import java.util.List;

public class ReopenPersistHandler
extends ClaimHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        ReopenContext context = (ReopenContext)aContext;
        HTSTask task = context.getPersistedTask();
        task.setStatus(context.getStatusManagement().getFinalStatus(task).toString());
        DeadlineInstanceBuilder builder = new DeadlineInstanceBuilder(task);
        List<HTSDeadlineInstance> deadlineInstances = builder.getDeadlineInstances();
        if (builder.wasDurationDeadline()) {
            Date createDate = new Date(task.getCreatedOn());
            for (HTSDeadlineInstance deadlineInstance : deadlineInstances) {
                long newTimeout = deadlineInstance.getTimeout() - (deadlineInstance.getTimeout() - createDate.getTime());
                deadlineInstance.setTimeout(newTimeout);
            }
        }
        task.setHtsDeadlineInstances(deadlineInstances);
        DAOFactory.getFactory().buildTaskDAO().update(task);
        this.handleNextRequest(context);
    }
}

