/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.internal.hts.apiHandlers.AssignFolderToTasksHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.UsTaskOpenJPADAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSFolder;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.FolderUtils;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.List;

public class UpdateInboxesPersistHandler
extends AssignFolderToTasksHandler {
    @Override
    public void handleRequestImpl(IAbstractContext context) throws HumanTaskServiceException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"HTS: UpdateInboxesPersistHandler: 1 : FolderlessTasksTotalUpdateTime");
        TaskDAO dao = DAOFactory.getFactory().buildTaskDAO();
        if (dao != null && dao instanceof UsTaskOpenJPADAO) {
            ((UsTaskOpenJPADAO)dao).setContext(context);
        }
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("UpdateInboxesPersistHandler : AssignFolderToTasksHandler : 1 : Trying to get folderless tasks.");
        ZipiTimer zipiTimer1 = ZipiBridge.startTimer((String)"HTS: UpdateInboxesPersistHandler: 1A : FolderlessTasksFetchTime");
        List<HTSTask> tasks = dao.findFolderlessTasks(context.getUsTaskUser(), context.getCurrentUserRolesAndGroups());
        zipiTimer1.stop();
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("UpdateInboxesPersistHandler : AssignFolderToTasksHandler : 2 : Folderless tasks count : " + (tasks != null ? tasks.size() : 0));
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("UpdateInboxesPersistHandler : AssignFolderToTasksHandler : 3 : Trying to assign folders for folderless tasks");
        ZipiTimer zipiTimer2 = ZipiBridge.startTimer((String)"HTS: UpdateInboxesPersistHandler: 1B : FolderlessTasksFolderAssignTime");
        context.getTransactionHandler().beginTransaction();
        try {
            for (HTSTask task : tasks) {
                FolderUtils.makeFolder(HTSFolder.UI_FOLDERS.INBOX.name(), HTSFolder.TYPE.PRIVATE, context.getUsTaskUser(), task);
                dao.update(task);
            }
            context.getTransactionHandler().commitTransaction();
        }
        catch (RuntimeException e) {
            context.getTransactionHandler().rollbackTransaction();
            Utils.throwHumanTaskServiceException(e);
        }
        zipiTimer2.stop();
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("UpdateInboxesPersistHandler : AssignFolderToTasksHandler : 4 : Folders assigned for folderless tasks");
        zipiTimer.stop();
        this.handleNextRequest(context);
    }
}

