/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.persist;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.DelegateHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.UpdateManualTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.ChangedHumanRoleMode;
import com.ibm.cognos.internal.hts.apiHandlers.context.DelegateContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.UpdateTaskDetailsContext;
import com.ibm.cognos.internal.hts.deadlines.DeadLineScheduler;
import com.ibm.cognos.internal.hts.event.EventDispatcher;
import com.ibm.cognos.internal.hts.event.TaskUpdate;
import com.ibm.cognos.internal.hts.event.TaskUpdateDueDeadline;
import com.ibm.cognos.internal.hts.event.TaskUpdateEvent;
import com.ibm.cognos.internal.hts.event.TaskUpdateOwner;
import com.ibm.cognos.internal.hts.event.TaskUpdatePotentialOwner;
import com.ibm.cognos.internal.hts.event.TaskUpdatePriority;
import com.ibm.cognos.internal.hts.event.TaskUpdateStakeholder;
import com.ibm.cognos.internal.hts.event.TaskUpdateStartDeadline;
import com.ibm.cognos.internal.hts.event.TaskUpdateStatus;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadlineInstance;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.Registry;
import com.ibm.cognos.internal.hts.service.ws_ht.HandlerMapFactory;
import com.ibm.cognos.internal.hts.util.BiBusHeaderUtilities;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.DeadlineUtil;
import com.ibm.cognos.internal.hts.util.dao.HumanroleUtils;
import com.ibm.cognos.internal.hts.util.dao.TaskUtil;
import com.ibm.cognos.internal.hts.util.dao.humanrole.HumanRoleOrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineInstance;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineInstanceList;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineType;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.DelegateDocument;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UpdateTaskDetailsPersistHandler
extends UpdateManualTaskHandler {
    private boolean m_updateTask = false;

    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        UpdateTaskDetailsContext context = (UpdateTaskDetailsContext)aContext;
        HTSTask persistedTask = context.getPersistedTask();
        this.handleSubject(context, persistedTask);
        this.handleDescription(context, persistedTask);
        this.handlePriority(context, persistedTask);
        this.handleDeadlines(context, persistedTask);
        this.handlePotentialOwners(context, persistedTask);
        this.handleStakeholders(context, persistedTask);
        this.handleStatus(context, persistedTask);
        this.handleActualOwner(context, persistedTask);
        this.updateTask(persistedTask);
        this.handleNextRequest(context);
    }

    private void updateTask(HTSTask persistedTask) throws HumanTaskServiceException {
        if (this.m_updateTask) {
            TaskUtil.updateTask(persistedTask);
            Registry.getService(DeadLineScheduler.class).deadlineInstanceRemoved();
        }
    }

    private boolean checkUpdateValue(Object oldValue, Object newValue) {
        boolean isValid;
        boolean isValueUpdated = false;
        boolean bl = isValid = newValue != null;
        if (newValue instanceof String && isValid) {
            boolean bl2 = isValid = isValid && newValue.toString().length() > 0;
        }
        if (isValid && !oldValue.equals(newValue)) {
            isValueUpdated = true;
        }
        return isValueUpdated;
    }

    private UpdateResult checkUpdateValueForRoles(HTSTask persistedTask, List<HTSHumanRole> hTSHumanRoles, TGenericHumanRole newHumanRoles) throws HumanTaskServiceException {
        Set<String> newUsersOrGroups = this.getUsersOrGroups(newHumanRoles);
        HashSet<String> oldUsersOrGroups = new HashSet<String>();
        for (int i = 0; i < hTSHumanRoles.size(); ++i) {
            HTSHumanRole hTSHumanRole = hTSHumanRoles.get(i);
            oldUsersOrGroups.add(hTSHumanRole.getHtsTaskUser().getUserToken());
        }
        boolean updates = !newUsersOrGroups.equals(oldUsersOrGroups);
        Set<String> removals = this.diff(oldUsersOrGroups, newUsersOrGroups);
        Set<String> associations = this.findCurrentAssociations(persistedTask, hTSHumanRoles);
        boolean associationsRemoved = false;
        associationsRemoved = !associations.isEmpty() ? removals.contains(associations.iterator().next()) : !removals.isEmpty();
        return new UpdateResult(updates, associationsRemoved);
    }

    private Set<String> findCurrentAssociations(HTSTask persistedTask, List<HTSHumanRole> hTSHumanRole) {
        HashSet<String> associations = new HashSet<String>();
        HTSTaskUser owner = persistedTask.getActualOwner();
        if (owner != null) {
            String userAssociation = null;
            for (HTSHumanRole pos : hTSHumanRole) {
                if (pos.getHtsTaskUser().isGroup() || !owner.equals(pos.getHtsTaskUser())) continue;
                userAssociation = pos.getHtsTaskUser().getUserToken();
                break;
            }
            int groupCount = 0;
            String groupAssociation = null;
            for (HTSHumanRole pos : hTSHumanRole) {
                if (!pos.getHtsTaskUser().isGroup()) continue;
                ++groupCount;
                groupAssociation = pos.getHtsTaskUser().getUserToken();
            }
            if (groupCount == 0 && userAssociation != null) {
                associations.add(userAssociation);
            } else if (groupCount == 1 && userAssociation == null) {
                associations.add(groupAssociation);
            }
        }
        return associations;
    }

    private Set<String> diff(Set<String> alpha, Set<String> omega) {
        HashSet<String> alphaCopy = new HashSet<String>();
        alphaCopy.addAll(alpha);
        alphaCopy.removeAll(omega);
        return alphaCopy;
    }

    private Set<String> getUsersOrGroups(TGenericHumanRole genericHumanRole) throws HumanTaskServiceException {
        if (genericHumanRole == null) {
            return new HashSet<String>();
        }
        OrganizationalEntityDocument orgEntDoc = HTSSDKUtils.getOrganizationalEntity(genericHumanRole.getFrom().getLiteral());
        String[] groups = new String[]{};
        String[] users = new String[]{};
        if (orgEntDoc.getOrganizationalEntity().sizeOfGroupsArray() != 0 && orgEntDoc.getOrganizationalEntity().getGroupsArray(0) != null) {
            groups = orgEntDoc.getOrganizationalEntity().getGroupsArray(0).getGroupArray();
        }
        if (orgEntDoc.getOrganizationalEntity().sizeOfUsersArray() != 0 && orgEntDoc.getOrganizationalEntity().getUsersArray(0) != null) {
            users = orgEntDoc.getOrganizationalEntity().getUsersArray(0).getUserArray();
        }
        HashSet<String> all = new HashSet<String>();
        all.addAll(Arrays.asList(groups));
        all.addAll(Arrays.asList(users));
        return all;
    }

    private boolean checkUpdateValueForDeadlines(List<HTSDeadlineInstance> htsDeadlineInstances, DeadlineInstanceList deadlines) {
        int i;
        boolean isDeadlineUpdated = false;
        if (deadlines.getDeadlineInstanceArray().length == 0) {
            return false;
        }
        HashMap<String, Long> newDeadlineMap = new HashMap<String, Long>();
        DeadlineInstance[] deadlineInstanceArr = deadlines.getDeadlineInstanceArray();
        for (i = 0; i < deadlineInstanceArr.length; ++i) {
            DeadlineInstance deadlineInst = deadlineInstanceArr[i];
            newDeadlineMap.put(deadlineInst.getType().toString(), new Long(deadlineInst.getDate().getTimeInMillis()));
        }
        isDeadlineUpdated = newDeadlineMap.size() != htsDeadlineInstances.size();
        for (i = 0; i < htsDeadlineInstances.size() && !isDeadlineUpdated; ++i) {
            Long newTimeout;
            HTSDeadlineInstance deadlineInstance = htsDeadlineInstances.get(i);
            Long oldTimeout = deadlineInstance.getTimeout();
            String oldType = deadlineInstance.getHtsDeadline().getHtsDeadlinetype();
            isDeadlineUpdated = newDeadlineMap.containsKey(oldType) ? !oldTimeout.equals(newTimeout = (Long)newDeadlineMap.get(oldType)) : true;
        }
        return isDeadlineUpdated;
    }

    private void updateDeadline(IAbstractContext context, HTSTask persistedTask, DeadlineInstance newDeadlineObj, HTSDeadline.DEADLINE_TYPE type) {
        List<HTSDeadlineInstance> deadlineInstances = persistedTask.getHtsDeadlineInstance();
        if (!this.checkForAddDeadline(context, persistedTask, newDeadlineObj, type)) {
            for (HTSDeadlineInstance hTSDeadlineInstance : deadlineInstances) {
                TaskUpdateEvent event;
                TaskUpdate update;
                long newTimeout;
                if (!type.equals((Object)HTSDeadline.DEADLINE_TYPE.valueOf(hTSDeadlineInstance.getHtsDeadline().getHtsDeadlinetype())) || !this.checkUpdateValue(new Long(newTimeout = newDeadlineObj.getDate().getTimeInMillis()), hTSDeadlineInstance.getTimeout())) continue;
                long oldTimeout = hTSDeadlineInstance.getTimeout();
                hTSDeadlineInstance.setTimeout(newTimeout);
                this.m_updateTask = true;
                if (DeadlineType.START.equals(newDeadlineObj.getType())) {
                    update = new TaskUpdateStartDeadline(context, oldTimeout, newTimeout);
                    event = new TaskUpdateEvent(this, update);
                    EventDispatcher.instance().fireEvent(event);
                    continue;
                }
                if (!DeadlineType.COMPLETE.equals(newDeadlineObj.getType())) continue;
                update = new TaskUpdateDueDeadline(context, oldTimeout, newTimeout);
                event = new TaskUpdateEvent(this, update);
                EventDispatcher.instance().fireEvent(event);
            }
        }
    }

    private boolean checkForAddDeadline(IAbstractContext context, HTSTask persistedTask, DeadlineInstance newDeadlineObj, HTSDeadline.DEADLINE_TYPE type) {
        List<HTSDeadlineInstance> deadlineInstances = persistedTask.getHtsDeadlineInstance();
        boolean found = DeadlineUtil.deadlineExists(type, deadlineInstances);
        if (!found) {
            HTSDeadlineInstance deadlineInstance = new HTSDeadlineInstance();
            long newTimeout = newDeadlineObj.getDate().getTimeInMillis();
            deadlineInstance.setTimeout(newTimeout);
            deadlineInstance.setId(GuidUtils.create());
            deadlineInstance.setHtsTask(persistedTask);
            HTSDeadline deadline = DeadlineUtil.getDeadlineFromTaskClass(persistedTask, type);
            if (deadline != null) {
                deadlineInstance.setDeadlineSignature(deadline.getDeadlineSignature());
                deadlineInstances.add(deadlineInstance);
                this.m_updateTask = true;
                if (DeadlineType.START.equals(newDeadlineObj.getType())) {
                    TaskUpdateStartDeadline update = new TaskUpdateStartDeadline(context, newTimeout);
                    TaskUpdateEvent event = new TaskUpdateEvent(this, update);
                    EventDispatcher.instance().fireEvent(event);
                } else if (DeadlineType.COMPLETE.equals(newDeadlineObj.getType())) {
                    TaskUpdateDueDeadline update = new TaskUpdateDueDeadline(context, newTimeout);
                    TaskUpdateEvent event = new TaskUpdateEvent(this, update);
                    EventDispatcher.instance().fireEvent(event);
                }
            }
        }
        return !found;
    }

    private void handlePriority(UpdateTaskDetailsContext context, HTSTask persistedTask) {
        boolean updated;
        BigInteger passedPriority = context.getPriority();
        Integer persistedPriority = persistedTask.getPriority();
        boolean bl = updated = passedPriority != null && !persistedPriority.equals(passedPriority.intValue());
        if (null != context.getPriority() && updated) {
            persistedTask.setPriority(passedPriority.intValue());
            this.m_updateTask = true;
            TaskUpdatePriority update = new TaskUpdatePriority(context, persistedPriority, passedPriority.intValue());
            TaskUpdateEvent event = new TaskUpdateEvent(this, update);
            EventDispatcher.instance().fireEvent(event);
        }
    }

    private void handleActualOwner(UpdateTaskDetailsContext context, HTSTask persistedTask) throws HumanTaskServiceException {
        String newValue = context.getActualOwner();
        String oldValue = persistedTask.getActualOwner() != null ? persistedTask.getActualOwner().getUserToken() : "";
        boolean update = this.checkUpdateValue(oldValue, newValue);
        if (update) {
            DelegateDocument delegate = DelegateDocument.Factory.newInstance();
            delegate.addNewDelegate().setIdentifier(persistedTask.getId());
            OrganizationalEntityDocument orgDoc = OrganizationalEntityDocument.Factory.newInstance();
            TOrganizationalEntity org = orgDoc.addNewOrganizationalEntity();
            org.addNewUsers().addNewUser().setStringValue(context.getActualOwner());
            delegate.getDelegate().setOrganizationalEntity(org);
            BIBusEnvelope delegateEnvelope = BiBusHeaderUtilities.getHeadedEnvelope(context.getHeader());
            try {
                delegateEnvelope.getBody().add(HTSSDKUtils.marshallAPIObjectToElement(delegate));
            }
            catch (Exception e) {
                Utils.throwHumanTaskServiceException(e);
            }
            DelegateHandler handler = new DelegateHandler(false);
            DelegateContext newContext = (DelegateContext)handler.makeContext(delegateEnvelope);
            newContext.setPersistedTask(context.getPersistedTask());
            handler.handleRequest(newContext);
            context.setOwnerChanged(newContext.hasOwnerChanged());
            TaskUpdateOwner taskUpdate = new TaskUpdateOwner(context, oldValue, newValue);
            TaskUpdateEvent event = new TaskUpdateEvent(this, taskUpdate);
            EventDispatcher.instance().fireEvent(event);
            this.m_updateTask = true;
        }
    }

    private void handleStakeholders(UpdateTaskDetailsContext context, HTSTask persistedTask) throws HumanTaskServiceException {
        if (null != context.getTaskStakeHolders()) {
            ArrayList<HTSHumanRole> taskStakeholderRoles = new ArrayList<HTSHumanRole>();
            UpdateResult updateResult = this.checkUpdateValueForRoles(persistedTask, persistedTask.getHumanroles(HTSRole.Roles.TASK_STAKEHOLDERS), context.getTaskStakeHolders());
            if (updateResult.updated) {
                TaskUpdateEvent event;
                TaskUpdateStakeholder taskUpdate;
                new HumanRoleOrganizationalEntityConverter(context).getHumanRolePojos(taskStakeholderRoles, new TGenericHumanRole[]{context.getTaskStakeHolders()}, HTSRole.Roles.TASK_STAKEHOLDERS);
                HumanroleUtils.updateHumanRoles(context, persistedTask, taskStakeholderRoles, HTSRole.Roles.TASK_STAKEHOLDERS);
                this.m_updateTask = true;
                List<HTSHumanRole> added = context.getChangedHumanRoles(ChangedHumanRoleMode.CHANGED_ROLE_TYPE_ADDED, HTSRole.Roles.TASK_STAKEHOLDERS);
                List<HTSHumanRole> removed = context.getChangedHumanRoles(ChangedHumanRoleMode.CHANGED_ROLE_TYPE_REMOVED, HTSRole.Roles.TASK_STAKEHOLDERS);
                for (HTSHumanRole humanRole : added) {
                    taskUpdate = new TaskUpdateStakeholder(context, TaskUpdate.Type.ADD, humanRole.getHtsTaskUser().getUserToken());
                    event = new TaskUpdateEvent(this, taskUpdate);
                    EventDispatcher.instance().fireEvent(event);
                }
                for (HTSHumanRole humanRole : removed) {
                    taskUpdate = new TaskUpdateStakeholder(context, TaskUpdate.Type.REMOVE, humanRole.getHtsTaskUser().getUserToken());
                    event = new TaskUpdateEvent(this, taskUpdate);
                    EventDispatcher.instance().fireEvent(event);
                }
            }
        }
    }

    private void handlePotentialOwners(UpdateTaskDetailsContext context, HTSTask persistedTask) throws HumanTaskServiceException {
        if (null != context.getPotentialOwner()) {
            ArrayList<HTSHumanRole> potentialOwnerRoles = new ArrayList<HTSHumanRole>();
            UpdateResult updateResult = this.checkUpdateValueForRoles(persistedTask, persistedTask.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS), context.getPotentialOwner());
            if (updateResult.updated) {
                TaskUpdateEvent event;
                TaskUpdatePotentialOwner taskUpdate;
                new HumanRoleOrganizationalEntityConverter(context).getHumanRolePojos(potentialOwnerRoles, new TGenericHumanRole[]{context.getPotentialOwner()}, HTSRole.Roles.POTENTIAL_OWNERS);
                HumanroleUtils.updateHumanRoles(context, persistedTask, potentialOwnerRoles, HTSRole.Roles.POTENTIAL_OWNERS);
                if (updateResult.removals || persistedTask.getActualOwner() == null) {
                    this.checkTaskState(persistedTask, context, potentialOwnerRoles);
                }
                this.m_updateTask = true;
                List<HTSHumanRole> added = context.getChangedHumanRoles(ChangedHumanRoleMode.CHANGED_ROLE_TYPE_ADDED, HTSRole.Roles.POTENTIAL_OWNERS);
                List<HTSHumanRole> removed = context.getChangedHumanRoles(ChangedHumanRoleMode.CHANGED_ROLE_TYPE_REMOVED, HTSRole.Roles.POTENTIAL_OWNERS);
                for (HTSHumanRole humanRole : added) {
                    taskUpdate = new TaskUpdatePotentialOwner(context, TaskUpdate.Type.ADD, humanRole.getHtsTaskUser().getUserToken());
                    event = new TaskUpdateEvent(this, taskUpdate);
                    EventDispatcher.instance().fireEvent(event);
                }
                for (HTSHumanRole humanRole : removed) {
                    taskUpdate = new TaskUpdatePotentialOwner(context, TaskUpdate.Type.REMOVE, humanRole.getHtsTaskUser().getUserToken());
                    event = new TaskUpdateEvent(this, taskUpdate);
                    EventDispatcher.instance().fireEvent(event);
                }
            }
        }
    }

    private void checkTaskState(HTSTask persistedTask, AbstractContext context, List<HTSHumanRole> potentialOwnerRoles) throws HumanTaskServiceException {
        TStatus.Enum finalStatus = context.getStatusManagement().getFinalStatus(persistedTask);
        HTSTaskUser owner = persistedTask.getActualOwner();
        boolean ownerFound = false;
        if (owner != null) {
            for (HTSHumanRole pos : potentialOwnerRoles) {
                if (pos.getHtsTaskUser().isGroup() || !owner.equals(pos.getHtsTaskUser())) continue;
                ownerFound = true;
                break;
            }
            if (!ownerFound) {
                for (HTSHumanRole pos : potentialOwnerRoles) {
                    Set<String> groupMembers;
                    if (!pos.getHtsTaskUser().isGroup() || !(groupMembers = UserUtils.instance().expandGroup(context, pos.getHtsTaskUser())).contains(owner.getUserToken())) continue;
                    ownerFound = true;
                    break;
                }
            }
        }
        if (TStatus.RESERVED == finalStatus && potentialOwnerRoles.size() == 1 && !potentialOwnerRoles.get(0).getHtsTaskUser().isGroup()) {
            persistedTask.setStatus(finalStatus.toString());
            HTSTaskUser user = potentialOwnerRoles.get(0).getHtsTaskUser();
            if (owner == null || !user.equals(owner)) {
                persistedTask.setActualOwner(user);
                context.setOwnerChanged(true);
            }
        } else if (owner != null && !ownerFound) {
            persistedTask.setActualOwner(null);
            context.setOwnerChanged(true);
        }
        persistedTask.setStatus(finalStatus.toString());
    }

    private void handleSubject(UpdateTaskDetailsContext context, HTSTask persistedTask) {
    }

    private void handleDescription(UpdateTaskDetailsContext context, HTSTask persistedTask) {
    }

    private void handleStatus(UpdateTaskDetailsContext context, HTSTask persistedTask) throws HumanTaskServiceException {
        if (null != context.getStatusOperation()) {
            String oldStatus = persistedTask.getStatus();
            String operation = context.getStatusOperation().toString();
            IAPIHandler handler = HandlerMapFactory.getHandlerMap().getHandler(operation);
            IAbstractContext newContext = handler.makeContext(context.getRequest());
            newContext.setOperationName(operation);
            newContext.setPersistedTask(context.getPersistedTask());
            handler.handleRequest(newContext);
            String newStatus = persistedTask.getStatus();
            if (oldStatus != null && !oldStatus.equals(newStatus)) {
                TaskUpdateStatus taskUpdate = new TaskUpdateStatus(context, oldStatus, newStatus);
                TaskUpdateEvent event = new TaskUpdateEvent(this, taskUpdate);
                EventDispatcher.instance().fireEvent(event);
            }
        } else {
            HTSHumanRole htsHumanRole;
            List<HTSHumanRole> htsHumanRoles = persistedTask.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS);
            if (htsHumanRoles.size() == 1 && persistedTask.getStatus().equals(TStatus.READY.toString()) && !(htsHumanRole = htsHumanRoles.get(0)).getHtsTaskUser().isGroup()) {
                persistedTask.setStatus(TStatus.RESERVED.toString());
                persistedTask.setActualOwner(htsHumanRole.getHtsTaskUser());
            }
        }
    }

    private void handleDeadlines(UpdateTaskDetailsContext context, HTSTask persistedTask) throws HumanTaskServiceException {
        DeadlineInstance[] deadlineArr;
        boolean update;
        DeadlineInstanceList deadlines = context.getDeadlines();
        if (deadlines != null && (update = this.checkUpdateValueForDeadlines(persistedTask.getHtsDeadlineInstance(), context.getDeadlines())) && (deadlineArr = deadlines.getDeadlineInstanceArray()).length > 0) {
            for (int i = 0; i < deadlineArr.length; ++i) {
                DeadlineInstance newDeadlineObj = deadlineArr[i];
                if (DeadlineType.START.equals(newDeadlineObj.getType())) {
                    if (!newDeadlineObj.getNotify()) continue;
                    this.updateDeadline(context, persistedTask, newDeadlineObj, HTSDeadline.DEADLINE_TYPE.START);
                    continue;
                }
                if (!DeadlineType.COMPLETE.equals(newDeadlineObj.getType()) || !newDeadlineObj.getNotify()) continue;
                this.updateDeadline(context, persistedTask, newDeadlineObj, HTSDeadline.DEADLINE_TYPE.COMPLETE);
            }
        }
    }

    private static class UpdateResult {
        final boolean updated;
        final boolean removals;

        public UpdateResult(boolean updated, boolean removals) {
            this.updated = updated;
            this.removals = removals;
        }
    }
}

