/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.apiHandlers.response;

import com.ibm.cognos.internal.hts.apiHandlers.GetTaskInfoHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.GetTaskInfoContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadlineInstance;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.HumanroleUtils;
import com.ibm.cognos.internal.hts.util.dao.builder.PresentationElementsBuilder;
import com.ibm.cognos.internal.hts.util.dao.builder.TaskQueryResultRowBuilder;
import com.ibm.cognos.internal.hts.util.dao.humanrole.HumanRoleOrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.util.dao.humanrole.OrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.cognos.internal.hts.ws_ht.api.TTask;
import com.ibm.cognos.internal.hts.ws_ht.api.TTaskAbstract;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineInstance;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineInstanceList;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineType;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlinesDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetTaskInfoResponseDocument;
import java.math.BigInteger;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class GetTaskInfoResponseHandler
extends GetTaskInfoHandler {
    @Override
    public void handleRequestImpl(IAbstractContext aContext) throws HumanTaskServiceException {
        HTSMessage htsMsg;
        GetTaskInfoContext context = (GetTaskInfoContext)aContext;
        HTSTask task = context.getPersistedTask();
        GetTaskInfoResponseDocument response = GetTaskInfoResponseDocument.Factory.newInstance();
        TTask tTask = response.addNewGetTaskInfoResponse().addNewTask();
        if (task.getActivationTime() != null) {
            tTask.setActivationTime(TimeUtils.toUTCCalendar(task.getActivationTime()));
        }
        tTask.setTaskOperation(task.getOperation());
        tTask.setCompleteByExists(false);
        if (task.getCreatedOn() != null) {
            tTask.setCreatedOn(TimeUtils.toUTCCalendar(task.getCreatedOn()));
            tTask.setEscalated(false);
        }
        if (task.getExpirationTime() != null) {
            tTask.setExpirationTime(TimeUtils.toUTCCalendar(task.getExpirationTime()));
        }
        tTask.setHasComments(task.getHtsThreads() != null && task.getHtsThreads().size() > 0);
        tTask.setHasFault(false);
        tTask.setHasOutput(false);
        tTask.setHasPotentialOwners(false);
        tTask.setId(task.getId());
        tTask.setIsSkipable(task.isSkipable());
        if (task.getName() != null) {
            tTask.setName(new QName(task.getName()));
        } else {
            tTask.setName(new QName(""));
        }
        PresentationElementsBuilder presElemBuilder = new PresentationElementsBuilder(task, aContext);
        String lang = context.getHeader().getProductLanguage();
        this.buildElementForTask(lang, presElemBuilder, tTask);
        tTask.setPrimarySearchBy(null);
        if (task.getPriority() != null) {
            tTask.setPriority(BigInteger.valueOf(task.getPriority().intValue()));
        }
        tTask.setRenderingMethodExists(false);
        tTask.setStartByExists(false);
        tTask.setStatus(TStatus.Enum.forString((String)task.getStatus()));
        tTask.setTaskType(task.getHtsTaskclass().getTaskType());
        List<HTSMessage> htsMsgList = task.getHtsMessages();
        if (tTask.getTaskOperation().equals("createPushNotificationTask") && null != htsMsgList && htsMsgList.size() > 0 && (htsMsg = htsMsgList.get(0)) != null) {
            String htsMsgStr = htsMsg.getMessage();
            String additionalData = this.getAdditionalData(htsMsgStr);
            String description = this.getDescription(htsMsgStr);
            tTask.setAdditionalData(additionalData);
            tTask.setPresentationDescription(description);
        }
        this.addHumanRoles(tTask, context);
        this.addDeadlinesToTask(tTask, task);
        HTSSDKUtils.setTaskClassProperties((XmlObject)tTask, task.getHtsTaskclass().getHtsTaskClassProperties());
        HTSSDKUtils.setRolesForTask((XmlObject)tTask, HumanroleUtils.getRoles(task, context));
        this.addTaskIconToTask(tTask, task);
        HTSTaskUser user = UserUtils.instance().getUser(context.getHeader());
        String taskReadLevelForCurrentUser = UserUtils.instance().getTaskReadLevelForUser(task, user);
        HTSSDKUtils.setTaskReadLevelForCurrentUser((XmlObject)tTask, taskReadLevelForCurrentUser);
        context.setAPIResponseObject(response);
        this.handleNextRequest(context);
    }

    private String getDescription(String htsMsgStr) {
        String result = "";
        String queryExpression = "declare namespace _1='http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1'$this/createPushNotificationTask/_1:pushNotificationTask/_1:description";
        result = this.getNodeData(htsMsgStr, queryExpression);
        return result;
    }

    private String getAdditionalData(String htsMsgStr) {
        String result = "";
        String queryExpression = "declare namespace _1='http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1'$this/createPushNotificationTask/_1:pushNotificationTask/_1:additionalData";
        result = this.getNodeData(htsMsgStr, queryExpression);
        return result;
    }

    private String getNodeData(String htsMsgStr, String queryExpression) {
        String result = "";
        try {
            XmlObject anyXML = XmlObject.Factory.parse((String)htsMsgStr);
            XmlObject[] nodeList = anyXML.selectPath(queryExpression);
            if (nodeList.length > 0) {
                result = ((SimpleValue)nodeList[0]).getStringValue();
            } else {
                Utils.debug("GetTaskInfoResponseHandler getNodeData query " + queryExpression + " did not return any result");
            }
        }
        catch (XmlException ex) {
            Utils.logException(ex);
        }
        return result;
    }

    private void addHumanRoles(TTask tTask, IAbstractContext context) throws HumanTaskServiceException {
        HTSTask task = context.getPersistedTask();
        HumanRoleOrganizationalEntityConverter hrConverter = new HumanRoleOrganizationalEntityConverter(context);
        List<HTSHumanRole> hrs = task.getHumanroles(HTSRole.Roles.BUSINESS_ADMINISTRATORS);
        TOrganizationalEntity toe = ((OrganizationalEntityConverter)hrConverter).getOrganizationalEntity(hrs).getOrganizationalEntity();
        tTask.setBusinessAdministrators(toe);
        hrs = task.getHumanroles(HTSRole.Roles.NOTIFICATION_RECIPIENTS);
        toe = ((OrganizationalEntityConverter)hrConverter).getOrganizationalEntity(hrs).getOrganizationalEntity();
        tTask.setNotificationRecipients(toe);
        hrs = task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS);
        toe = ((OrganizationalEntityConverter)hrConverter).getOrganizationalEntity(hrs).getOrganizationalEntity();
        tTask.setPotentialOwners(toe);
        hrs = task.getHumanroles(HTSRole.Roles.TASK_STAKEHOLDERS);
        toe = ((OrganizationalEntityConverter)hrConverter).getOrganizationalEntity(hrs).getOrganizationalEntity();
        tTask.setTaskStakeholders(toe);
        HTSTaskUser owner = task.getActualOwner();
        HTSTaskUser initiator = task.getTaskInitiator();
        HTSTaskUser creator = task.getCreatedBy();
        if (owner != null) {
            tTask.setActualOwner(owner.getUserToken());
        }
        if (initiator != null) {
            tTask.setTaskInitiator(initiator.getUserToken());
        }
        tTask.setCreatedBy(creator.getUserToken());
        HumanroleUtils.setFormattedHumanRoles((XmlObject)tTask, task, context);
    }

    private void addDeadlinesToTask(TTask tTask, HTSTask task) throws HumanTaskServiceException {
        List<HTSDeadlineInstance> hTSDeadlineInstances = task.getHtsDeadlineInstance();
        DeadlinesDocument deadlinesDoc = DeadlinesDocument.Factory.newInstance();
        DeadlineInstanceList deadlines = deadlinesDoc.addNewDeadlines();
        for (HTSDeadlineInstance hTSDeadlineInstance : hTSDeadlineInstances) {
            HTSDeadline hTSDeadline = hTSDeadlineInstance.getHtsDeadline();
            DeadlineInstance deadline = deadlines.addNewDeadlineInstance();
            deadline.setDate(TimeUtils.toUTCCalendar(hTSDeadlineInstance.getTimeout()));
            deadline.setType(DeadlineType.Enum.forString((String)hTSDeadline.getHtsDeadlinetype()));
        }
        HTSSDKUtils.setDeadlines((XmlObject)tTask, deadlinesDoc);
    }

    private void addTaskIconToTask(TTask tTask, HTSTask task) throws HumanTaskServiceException {
        String taskIcon = TaskQueryResultRowBuilder.getImageIconPath(task);
        if (taskIcon != null && taskIcon.length() > 0) {
            HTSSDKUtils.setTaskIconPath((XmlObject)tTask, taskIcon);
        }
    }

    private void buildElementForTask(String lang, PresentationElementsBuilder presElemBuilder, TTask tTask) {
        String name = presElemBuilder.getName();
        String subject = presElemBuilder.getSubject(lang);
        TTaskAbstract m_taskAbstract = TTaskAbstract.Factory.newInstance();
        if (name != null) {
            m_taskAbstract.setPresentationName(name);
            tTask.setPresentationName(name);
        }
        if (subject != null) {
            m_taskAbstract.setPresentationSubject(subject);
            tTask.setPresentationSubject(subject);
        }
    }
}

