/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deadlines;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.deadline.DeadlineRunContext;
import com.ibm.cognos.internal.hts.apiHandlers.notification.DeadlineEscalationNotificationHandler;
import com.ibm.cognos.internal.hts.deadlines.RunnerParams;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DeadlineInstanceRunner
implements Runnable {
    private RunnerParams m_params;

    public DeadlineInstanceRunner(RunnerParams params) {
        this.m_params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OpenJPAUtil trx = null;
        try {
            trx = new OpenJPAUtil(PersistenceUnit.HUMANTASK_SERVICE);
            trx.openSession();
            BIBusEnvelope env = this.getBiBusEnvelope();
            DeadlineRunContext drc = new DeadlineRunContext(env, this.m_params, trx);
            DeadlineEscalationNotificationHandler handler = new DeadlineEscalationNotificationHandler();
            handler.handleRequest(drc);
        }
        catch (HumanTaskServiceException e) {
            try {
                Utils.logException((Throwable)((Object)e));
                if (trx != null) {
                    trx.rollbackTransaction();
                }
            }
            catch (Throwable t) {
                Utils.logException((Throwable)((Object)e));
            }
        }
        finally {
            try {
                if (trx != null) {
                    trx.closeSession();
                }
            }
            catch (Throwable t) {
                Utils.logException(t);
            }
        }
    }

    private BIBusEnvelope getBiBusEnvelope() {
        BIBusEnvelope envelope = new BIBusEnvelope();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append("dummyOperationName");
        buffer.append(">");
        buffer.append("</");
        buffer.append("dummyOperationName");
        buffer.append(">");
        SAXReader reader = new SAXReader();
        StringReader inputMessageReader = new StringReader(buffer.toString());
        try {
            Document doc = reader.read((Reader)inputMessageReader);
            Element operationElement = doc.getRootElement();
            envelope.getBody().add(operationElement);
        }
        catch (DocumentException e) {
            Utils.logException(e);
        }
        return envelope;
    }
}

