/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deadlines;

import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.deadlines.DeadLineScheduler;
import com.ibm.cognos.internal.hts.deadlines.DeadlineInstanceRunner;
import com.ibm.cognos.internal.hts.deadlines.RunnerParams;
import com.ibm.cognos.internal.hts.persist.dao.DeadlineInstancesDAO;
import com.ibm.cognos.internal.hts.persist.dao.IDAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadlineInstance;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;

public class DeadlineSchedulerImpl
implements DeadLineScheduler {
    private long m_delay = DEFAULT_WAIT;
    private ITransactionHandler m_transHandler = new OpenJPAUtil(PersistenceUnit.HUMANTASK_SERVICE);
    private IDAOFactory m_daof;
    private Thread m_deadlineSchedulerThread;
    private volatile boolean m_isRunning;
    private static long DEFAULT_WAIT = 30000L;

    public DeadlineSchedulerImpl(IDAOFactory daof) {
        this.m_daof = daof;
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        this.setRunning(true);
        if (this.m_deadlineSchedulerThread == null) {
            this.m_deadlineSchedulerThread = new Thread((Runnable)this, "HTS.DeadlineScheduler");
            this.m_deadlineSchedulerThread.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.setRunning(false);
        this.m_deadlineSchedulerThread.interrupt();
        this.m_deadlineSchedulerThread = null;
    }

    @Override
    public synchronized void deadlineInstanceAdded() {
        this.notify();
    }

    @Override
    public synchronized void deadlineInstanceRemoved() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AbstractContext.setCurrentTransactionHandler(this.m_transHandler);
        while (this.isRunning()) {
            try {
                this.m_transHandler.openSession();
                HTSDeadlineInstance deadlineInstance = this.getEarliestDeadlineInstance();
                long deadlineDelay = this.computeDeadlineDelay(deadlineInstance);
                this.checkDeadlineExpiration(deadlineDelay, deadlineInstance);
            }
            catch (Throwable ex) {
                try {
                    Utils.logException(ex);
                    this.m_transHandler.rollbackTransaction();
                }
                catch (Throwable t) {
                    Utils.logException(t);
                }
            }
            finally {
                try {
                    this.m_transHandler.closeSession();
                }
                catch (Throwable ex) {
                    Utils.logException(ex);
                }
            }
        }
    }

    void setRunning(boolean isRunning) {
        this.m_isRunning = isRunning;
    }

    boolean isRunning() {
        return this.m_isRunning;
    }

    void setDelay(long delay) {
        this.m_delay = delay;
    }

    void setTransactionHandler(ITransactionHandler trx) {
        this.m_transHandler = trx;
    }

    private HTSDeadlineInstance getEarliestDeadlineInstance() {
        List<HTSDeadlineInstance> all = this.m_daof.buildDeadlineInstancesDAO().findEarliest(1);
        if (all.size() > 0) {
            return all.get(0);
        }
        return null;
    }

    private boolean deleteDeadLineInstance(HTSDeadlineInstance deadlineInstance) {
        boolean deleted = false;
        if (deadlineInstance != null) {
            DeadlineInstancesDAO dao = this.m_daof.buildDeadlineInstancesDAO();
            this.getEntityManager().clear();
            try {
                this.m_transHandler.beginTransaction();
                deleted = dao.deleteInstance(deadlineInstance);
                this.m_transHandler.commitTransaction();
            }
            catch (RuntimeException re) {
                this.m_transHandler.rollbackTransaction();
            }
        }
        return deleted;
    }

    private long computeDeadlineDelay(HTSDeadlineInstance deadlineInstance) {
        long deadlineDelay = this.m_delay;
        if (deadlineInstance != null) {
            Date now = new Date();
            deadlineDelay = deadlineInstance.getTimeout() - now.getTime();
            if (deadlineDelay > this.m_delay) {
                deadlineDelay = this.m_delay;
            }
        }
        return deadlineDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDeadlineExpiration(long deadlineDelay, HTSDeadlineInstance deadlineInstance) {
        if (deadlineDelay > 0L) {
            DeadlineSchedulerImpl deadlineSchedulerImpl = this;
            synchronized (deadlineSchedulerImpl) {
                try {
                    this.wait(deadlineDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        RunnerParams params = new RunnerParams();
        params.setTask(deadlineInstance.getHtsTask().getId());
        params.setDeadline(deadlineInstance.getHtsDeadline());
        params.setDeadlineInstanceId(deadlineInstance.getId());
        if (this.deleteDeadLineInstance(deadlineInstance)) {
            this.runDeadlineInstance(params);
        }
    }

    void runDeadlineInstance(RunnerParams params) {
        DeadlineInstanceRunner runner = new DeadlineInstanceRunner(params);
        Thread runnerThread = new Thread((Runnable)runner, "DeadlineInstanceRunner [" + params.getDeadlineInstanceId() + "]");
        runnerThread.start();
    }

    EntityManager getEntityManager() {
        return this.m_transHandler.getEntityManager();
    }
}

