/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class DeploymentClassLoader
extends URLClassLoader {
    public DeploymentClassLoader(URL[] urls) {
        super(urls);
    }

    public static DeploymentClassLoader createDeploymentClassLoader(File dir) throws MalformedURLException {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return new DeploymentClassLoader(new URL[0]);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                String ext;
                String string = ext = filename.lastIndexOf(".") == -1 ? "" : filename.substring(filename.lastIndexOf(".") + 1, filename.length());
                return "jar".equalsIgnoreCase(ext) || "zip".equalsIgnoreCase(ext);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            URI uri = files[i].toURI();
            urls.add(new URL("jar:" + uri.toURL() + "!/"));
        }
        return new DeploymentClassLoader(urls.toArray(new URL[urls.size()]));
    }

    public static void main(String[] args) {
        File lib = new File("E:\\installs\\cognos\\colororado\\working\\webapps\\p2pd\\WEB-INF\\lib");
        try {
            DeploymentClassLoader dcl = DeploymentClassLoader.createDeploymentClassLoader(lib);
            Class<?> clazz = dcl.loadClass("oracle.jdbc.OracleDriver");
            System.out.println(clazz.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

