/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.DeploymentCipherStreamSession;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.ibm.cognos.internal.hts.deployment.DeploymentFileVersioner;
import com.ibm.cognos.internal.hts.deployment.IDeploymentFileStream;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class DeploymentFileStream
implements IDeploymentFileStream {
    private CAMFactory camFactory;
    private byte[] encryptedPassword;
    private File deploymentFile;
    private Writer writer;
    private Reader reader;
    private FileInputStream fis;
    private FileOutputStream fos;
    private CipherOutputStream cos;
    private CipherInputStream cis;
    private GZIPInputStream zis;
    private GZIPOutputStream zos;
    private BufferedOutputStream bos;
    private BufferedInputStream bis;
    private int deploymenteVersion = -1;

    public DeploymentFileStream(String name, String password) throws CAMCryptoException, IOException, HumanTaskServiceException {
        this(DeploymentFileStream.getFile(name), password);
    }

    public DeploymentFileStream(File file, String password) throws CAMCryptoException, IOException, HumanTaskServiceException {
        this.deploymentFile = file;
        if (password != null) {
            this.camFactory = new CAMFactory();
            byte[] initDoc = "<initializeDocument><serviceID>SDS</serviceID></initializeDocument>".getBytes();
            this.camFactory.initialize(initDoc);
            this.setEncryptedPassword(password);
        }
    }

    @Override
    public Writer getDeploymentFileWriter() throws IOException, CAMCryptoException {
        this.fos = new FileOutputStream(this.deploymentFile);
        this.bos = new BufferedOutputStream(this.fos);
        this.zos = new GZIPOutputStream(this.bos);
        if (this.encryptedPassword != null) {
            DeploymentCipherStreamSession dcs = this.camFactory.createDeploymentCipherStreamSession(this.encryptedPassword);
            this.cos = dcs.createEncryptingOutputStream((OutputStream)this.zos);
        }
        this.writer = new OutputStreamWriter((OutputStream)(this.cos == null ? this.zos : this.cos), "UTF-8");
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        if (this.fos != null && this.writer != null) {
            this.writer.flush();
            if (this.cos != null) {
                this.cos.flush();
            }
            this.zos.flush();
            this.bos.flush();
            this.fos.flush();
            this.writer.close();
            this.writer = null;
            if (this.cos != null) {
                this.cos.close();
            }
            this.zos.close();
            this.bos.close();
            this.fos.close();
            this.fos = null;
        }
        if (this.reader != null && this.fis != null) {
            this.reader.close();
            if (this.cis != null) {
                this.cis.close();
            }
            this.bis.close();
            this.fis.close();
            this.reader = null;
            this.fis = null;
        }
    }

    @Override
    public Reader getDeploymentFileReader() throws IOException, CAMCryptoException {
        this.fis = new FileInputStream(this.deploymentFile);
        this.bis = new BufferedInputStream(this.fis);
        this.zis = new GZIPInputStream(this.bis);
        if (this.encryptedPassword != null) {
            DeploymentCipherStreamSession dcs = this.camFactory.createDeploymentCipherStreamSession(this.encryptedPassword);
            this.cis = dcs.createDecryptingInputStream((InputStream)this.zis);
        }
        this.reader = new InputStreamReader((InputStream)(this.cis == null ? this.zis : this.cis), "UTF-8");
        return this.reader;
    }

    private static File getFile(String name) throws IOException {
        File file;
        File existingFile;
        File deployment_dir = new File(".." + File.separator + "deployment");
        if (!deployment_dir.exists()) {
            deployment_dir.mkdir();
        }
        if ((existingFile = new File(deployment_dir, name)).exists()) {
            return existingFile;
        }
        if (name == null || name.equals("")) {
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy_HHmm");
            String date = sdf.format(new Date());
            name = "htsDeployment_" + date;
        }
        if (!name.endsWith(".xml")) {
            name = name + ".xml";
        }
        if (!(file = new File(deployment_dir, name + ".gz")).exists()) {
            file.createNewFile();
            Utils.debug("new deployment file at " + file.getAbsolutePath());
        } else {
            Utils.debug("existing deployment file at " + file.getAbsolutePath());
        }
        return file;
    }

    private void setEncryptedPassword(String password) throws CAMCryptoException, IOException {
        if (password != null) {
            EncryptingSession es = this.camFactory.createEncryptingSession();
            this.encryptedPassword = es.encryptData(password.getBytes());
            this.encryptedPassword = CryptoWrapper.encodeBase64((byte[])this.encryptedPassword);
        }
    }

    public int getDeploymenteVersion() throws HumanTaskServiceException {
        if (this.deploymenteVersion == -1) {
            this.deploymenteVersion = new DeploymentFileVersioner(this).getDeploymentVersion();
        }
        return this.deploymenteVersion;
    }
}

