/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment;

import com.ibm.cognos.internal.hts.deployment.DeploymentFileStream;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DeploymentFileVersioner
extends DefaultHandler {
    private static final String HUMAN_TASK_SERVICE_DEPLOYMENT = "HumanTaskServiceDeployment";
    private static final String VERSION_ATTRIBUTE = "version";
    private DeploymentFileStream deploymentFileStream;
    private int version = -1;

    public DeploymentFileVersioner(DeploymentFileStream deploymentFileStream) {
        this.deploymentFileStream = deploymentFileStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getDeploymentVersion() throws HumanTaskServiceException {
        if (this.version != -1) {
            return this.version;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        InputSource input_source = new InputSource(this.deploymentFileStream.getDeploymentFileReader());
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setContentHandler(this);
        reader.parse(input_source);
        try {
            this.deploymentFileStream.close();
        }
        catch (IOException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_IMPORT_FAILED, new Object[]{e.getMessage(), e});
        }
        catch (Throwable t) {
            block11: {
                try {
                    if (this.version != -1) break block11;
                    throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_IMPORT_FAILED, new Object[]{t.getMessage(), t});
                }
                catch (Throwable throwable) {
                    try {
                        this.deploymentFileStream.close();
                    }
                    catch (IOException e) {
                        throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_IMPORT_FAILED, new Object[]{e.getMessage(), e});
                    }
                    throw throwable;
                }
            }
            try {
                this.deploymentFileStream.close();
            }
            catch (IOException e) {
                throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_IMPORT_FAILED, new Object[]{e.getMessage(), e});
            }
        }
        return this.version;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals(HUMAN_TASK_SERVICE_DEPLOYMENT)) {
            String versionString = attributes.getValue(VERSION_ATTRIBUTE);
            this.version = Integer.valueOf(versionString);
            throw new SAXException("deployment version " + versionString);
        }
    }
}

