/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment;

import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.ibm.cognos.internal.annotations.dao.impl.DAOFactory;
import com.ibm.cognos.internal.hts.deployment.MetaDataSchemaTranslator;
import com.ibm.cognos.internal.hts.deployment.exports.TableTreeNodeFactory;
import com.ibm.cognos.internal.hts.deployment.exports.fetch.ExportFetchStrategyFactory;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.FixupStrategyFactory;
import com.ibm.cognos.internal.hts.deployment.id.AnnotationIdStrategy;
import com.ibm.cognos.internal.hts.deployment.id.DefaultIdStrategy;
import com.ibm.cognos.internal.hts.deployment.id.IdStrategy;
import com.ibm.cognos.internal.hts.deployment.imports.conflicts.ConflictResolverFactory;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.DeploymentSearchpathTranslations;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixupImportDelegateFactory;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.JPAPersistenceUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.schema.SchemaVersionChangeFactory;
import com.ibm.cognos.internal.hts.util.Utils;
import java.net.URL;
import java.util.Vector;

public class DeploymentResources {
    private DAOFactory annotationDaoFactory;
    private DeploymentSearchpathTranslations searchPathTranslations;
    private TableTreeNodeFactory tableTreeNodeFactory;
    private MetaDataSchemaTranslator metaDataSchemaTranslator;
    private FixupStrategyFactory fixupStrategyFactory;
    private ExportFetchStrategyFactory exportFetchStrategyFactory;
    private FixupImportDelegateFactory fixupImportDelegatefactory;
    private ConflictResolverFactory conflictResolverFactory;
    private PersistenceUnit persistenceUnit;
    private JobBiBusHeaders loggedInHeader;
    private IdStrategy idStrategy = new DefaultIdStrategy();
    private JPAPersistenceUtil persistenceUtil;
    private SchemaVersionChangeFactory schemaChangefactory;
    private String camUsername;
    private String camPassword;
    private String camNamespace;

    public TableTreeNodeFactory getTableTreeNodeFactory() {
        return this.tableTreeNodeFactory;
    }

    public void setTableTreeNodeFactory(TableTreeNodeFactory tableTreeNodeFactory) {
        this.tableTreeNodeFactory = tableTreeNodeFactory;
    }

    public FixupImportDelegateFactory getFixupImportDelegateFactory() {
        return this.fixupImportDelegatefactory;
    }

    public void setFixupImportDelegateFactory(FixupImportDelegateFactory fixupDelegateFactory) {
        this.fixupImportDelegatefactory = fixupDelegateFactory;
    }

    public FixupStrategyFactory getFixupStrategyFactory() {
        return this.fixupStrategyFactory;
    }

    public void setFixupStrategyFactory(FixupStrategyFactory fixupStrategyFactory) {
        this.fixupStrategyFactory = fixupStrategyFactory;
    }

    public ExportFetchStrategyFactory getExportFetchStrategyFactory() {
        return this.exportFetchStrategyFactory;
    }

    public void setExportFetchStrategyFactory(ExportFetchStrategyFactory exportFetchStrategyFactory) {
        this.exportFetchStrategyFactory = exportFetchStrategyFactory;
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(PersistenceUnit persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
        if (persistenceUnit.equals((Object)PersistenceUnit.ANNOTATIONS)) {
            this.setIdStrategy(new AnnotationIdStrategy(this));
        }
    }

    public String getCamUsername() {
        return this.camUsername;
    }

    public void setCamUsername(String camUsername) {
        this.camUsername = camUsername;
    }

    public String getCamPassword() {
        return this.camPassword;
    }

    public void setCamPassword(String camPassword) {
        this.camPassword = camPassword;
    }

    public MetaDataSchemaTranslator getMetaDataSchemaTranslator() {
        return this.metaDataSchemaTranslator;
    }

    public void setMetaDataSchemaTranslator(MetaDataSchemaTranslator metaDataSchemaTranslator) {
        this.metaDataSchemaTranslator = metaDataSchemaTranslator;
    }

    public String getCamNamespace() {
        return this.camNamespace;
    }

    public void setCamNamespace(String setCamNamespace) {
        this.camNamespace = setCamNamespace;
    }

    public SchemaVersionChangeFactory getSchemaChangefactory() {
        return this.schemaChangefactory;
    }

    public void setSchemaChangefactory(SchemaVersionChangeFactory schemaChangefactory) {
        this.schemaChangefactory = schemaChangefactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobBiBusHeaders getLoggedInHeader() throws SDKClientException, EMFSecurityException {
        ContentManagerServiceClientPort cmPort = null;
        try {
            if (this.loggedInHeader == null && this.getCamUsername() != null) {
                this.loggedInHeader = new JobBiBusHeaders();
                this.loggedInHeader.getBiBusHeader().setCAM(new CAM());
                this.loggedInHeader.getBiBusHeader().getCAM().setAction("logon");
                StringBuffer credentialXML = new StringBuffer();
                credentialXML.append("<credential>");
                credentialXML.append("<namespace>");
                credentialXML.append(this.getCamNamespace());
                credentialXML.append("</namespace>");
                credentialXML.append("<username>");
                credentialXML.append(this.getCamUsername());
                credentialXML.append("</username>");
                credentialXML.append("<password>");
                credentialXML.append(this.getCamPassword());
                credentialXML.append("</password>");
                credentialXML.append("</credential>");
                cmPort = Client.instance().getContentManagerServiceClient(this.loggedInHeader);
                XmlEncodedXML credentialXEX = new XmlEncodedXML(credentialXML.toString());
                cmPort.logon(credentialXEX, null);
            } else if (this.loggedInHeader != null) {
                this.loggedInHeader.getBiBusHeader().getCAM().setAction(null);
            } else {
                this.loggedInHeader = new JobBiBusHeaders();
                cmPort = Client.instance().getContentManagerServiceClient(this.loggedInHeader);
                this.loggedInHeader.getBiBusHeader().setCAM(new CAM());
                this.loggedInHeader.getBiBusHeader().getCAM().setAction("logon");
                cmPort.query("~~", new PropEnum[]{PropEnum.searchPath}, new Sort[0], new QueryOptions());
            }
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return this.loggedInHeader;
    }

    public JobBiBusHeaders _getLoggedInHeader() throws Exception {
        String endpoint = Client.instance().getEndpointString(1);
        ContentManagerService_PortType cmPort = new ContentManagerService_ServiceLocator().getcontentManagerService(new URL(endpoint));
        if (this.loggedInHeader == null && this.getCamUsername() != null) {
            this.loggedInHeader = new JobBiBusHeaders();
            StringBuffer credentialXML = new StringBuffer();
            credentialXML.append("<credential>");
            credentialXML.append("<namespace>");
            credentialXML.append(this.getCamNamespace());
            credentialXML.append("</namespace>");
            credentialXML.append("<username>");
            credentialXML.append(this.getCamUsername());
            credentialXML.append("</username>");
            credentialXML.append("<password>");
            credentialXML.append(this.getCamPassword());
            credentialXML.append("</password>");
            credentialXML.append("</credential>");
            XmlEncodedXML credentialXEX = new XmlEncodedXML(credentialXML.toString());
            cmPort.logon(credentialXEX, null);
        } else if (this.loggedInHeader != null) {
            this.loggedInHeader.getBiBusHeader().getCAM().setAction(null);
        } else {
            this.loggedInHeader = new JobBiBusHeaders();
            this.loggedInHeader.getBiBusHeader().setCAM(new CAM());
            this.loggedInHeader.getBiBusHeader().getCAM().setAction("logon");
            cmPort.query(new SearchPathMultipleObject("~~"), new PropEnum[]{PropEnum.searchPath}, new Sort[0], new QueryOptions());
        }
        return this.loggedInHeader;
    }

    public void logoff() throws EMFSecurityException {
        if (this.loggedInHeader != null) {
            AuthenticatorFactory.getInstance().logoff(this.loggedInHeader.getBiBusHeader());
        }
    }

    public void close() {
        try {
            this.logoff();
            if (this.persistenceUtil != null) {
                this.persistenceUtil.close();
            }
        }
        catch (EMFSecurityException e) {
            Utils.logException(e);
        }
    }

    public FormFieldVar[] makeFormFieldVars(String[] pairs) {
        Vector<FormFieldVar> all = new Vector<FormFieldVar>();
        for (int i = 0; i < pairs.length - 1; ++i) {
            FormFieldVar ffv = new FormFieldVar();
            ffv.setName(pairs[i]);
            ffv.setValue(pairs[++i]);
            ffv.setFormat(FormatEnum.not_encrypted);
            all.add(ffv);
        }
        Object[] ffv = new FormFieldVar[all.size()];
        all.copyInto(ffv);
        return ffv;
    }

    public DeploymentSearchpathTranslations getSearchPathTranslations() {
        return this.searchPathTranslations;
    }

    void setSearchPathTranslations(DeploymentSearchpathTranslations searchPathTranslations) {
        this.searchPathTranslations = searchPathTranslations;
    }

    public IdStrategy getIdStrategy() {
        return this.idStrategy;
    }

    public void setIdStrategy(IdStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    public JPAPersistenceUtil getPersistenceUtil() {
        if (this.persistenceUtil == null) {
            this.persistenceUtil = new JPAPersistenceUtil(this.persistenceUnit);
        }
        return this.persistenceUtil;
    }

    public DAOFactory getAnnotationDaoFactory() {
        return this.annotationDaoFactory == null ? (this.annotationDaoFactory = new DAOFactory()) : this.annotationDaoFactory;
    }

    public ConflictResolverFactory getConflictResolverFactory() {
        return this.conflictResolverFactory;
    }

    public void setConflictResolverFactory(ConflictResolverFactory conflictResolverFactory) {
        this.conflictResolverFactory = conflictResolverFactory;
    }
}

