/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.jsmcommon.jdbc.ConnectionOpener;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.HTSCnfgProperties;
import com.ibm.cognos.internal.annotations.dao.impl.DAOFactory;
import com.ibm.cognos.internal.annotations.schema.AnnotationVersion;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.deployment.DeploymentClassLoader;
import com.ibm.cognos.internal.hts.deployment.DeploymentFileStream;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.MetaDataSchemaTranslator;
import com.ibm.cognos.internal.hts.deployment.exports.TableTreeNodeExportVisitor;
import com.ibm.cognos.internal.hts.deployment.exports.TableTreeNodeFactory;
import com.ibm.cognos.internal.hts.deployment.exports.fetch.ExportFetchStrategyFactory;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.FixupStrategyFactory;
import com.ibm.cognos.internal.hts.deployment.imports.ImportReader;
import com.ibm.cognos.internal.hts.deployment.imports.conflicts.ConflictResolverFactory;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.DeploymentSearchpathTranslations;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixupImportDelegateFactory;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupportFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskSearchProperties;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.TaskSearchPropertiesOpenJPA;
import com.ibm.cognos.internal.hts.persist.dao.pojo.PojoCache;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.schema.IVersionUpdate;
import com.ibm.cognos.internal.hts.schema.PluginPropertySchemaVersionUpdateFactory;
import com.ibm.cognos.internal.hts.schema.SchemaUtil;
import com.ibm.cognos.internal.hts.schema.VersionUpdate;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.Registry;
import com.ibm.cognos.internal.hts.util.ArgParser;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.sql.Driver;
import java.util.Date;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.dom4j.Element;
import org.dom4j.Node;

public class DeploymentTool {
    private static String DEPLOYMENT_OVERWRITE_KEY = "deployment.import.overwrite";
    public static final String IMPORT_FILE_PATH = "importFile";
    public static final String CAM_NAMESPACE = "camNamespace";
    public static final String CAM_UNAME = "camUsername";
    public static final String CAM_PWORD = "camPassword";
    public static final String EXPORT_FILE_PATH = "exportFile";
    public static final String IMPORT_OVERWRITE = "overwrite";
    public static final String PASSWORD = "password";
    public static final String PERSISTENCE_UNIT = "persistenceUnit";
    public static final String LIB_DIR = "libDir";
    private IVersionUpdate version;
    private boolean importOverwrite = true;
    private static ICCLConfiguration m_iccl = null;
    private DeploymentResources resources;

    public DeploymentTool(PersistenceUnit persistenceUnit) throws HumanTaskServiceException {
        this(persistenceUnit, null, null, null);
    }

    public DeploymentTool(PersistenceUnit persistenceUnit, String camNamespace, String camUsername, String camPassword) throws HumanTaskServiceException {
        PojoCache.switchOff();
        Utils.setPrintToStdOut(true);
        this.resources = new DeploymentResources();
        this.resources.setCamPassword(camPassword);
        this.resources.setCamUsername(camUsername);
        this.resources.setCamNamespace(camNamespace);
        this.resources.setPersistenceUnit(persistenceUnit);
        this.resources.setFixupStrategyFactory(new FixupStrategyFactory());
        this.resources.setExportFetchStrategyFactory(new ExportFetchStrategyFactory());
        this.resources.setMetaDataSchemaTranslator(new MetaDataSchemaTranslator(persistenceUnit));
        this.resources.setFixupImportDelegateFactory(new FixupImportDelegateFactory());
        this.resources.setSearchPathTranslations(new DeploymentSearchpathTranslations());
        this.resources.setConflictResolverFactory(new ConflictResolverFactory());
        this.resources.setSchemaChangefactory(new PluginPropertySchemaVersionUpdateFactory(OpenJPAUtil.getNamedEntityManagerFactory(persistenceUnit), persistenceUnit));
        this.version = PersistenceUnit.ANNOTATIONS == persistenceUnit ? new AnnotationVersion(this.resources.getPersistenceUtil().getEntityManagerFactory(), new DAOFactory()) : new VersionUpdate();
        this.resources.setTableTreeNodeFactory(new TableTreeNodeFactory(this.resources));
        Boolean overwrite = Boolean.valueOf(HTSServerProperties.getInstance().getProperty(DEPLOYMENT_OVERWRITE_KEY));
        this.importOverwrite = overwrite == null ? true : overwrite;
        try {
            this.resources.getLoggedInHeader();
            String versionStr = HTSServerProperties.getInstance().getProperty(persistenceUnit.getName() + ".version");
            int currentVersion = 1;
            if (versionStr != null) {
                currentVersion = Integer.valueOf(versionStr);
            }
            JDBCConfigurationImpl conf = null;
            conf = OpenJPAUtil.createConfig();
            SchemaUtil util = new SchemaUtil(this.version, this.resources.getSchemaChangefactory(), conf);
            util.update(currentVersion, persistenceUnit);
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
    }

    public void importAll(String deployment, String password, String overwrite) throws HumanTaskServiceException {
        try {
            this.importAll(new DeploymentFileStream(deployment, password), overwrite);
        }
        catch (Exception e) {
            Utils.logException(e);
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()}, e);
        }
    }

    public void importAll(DeploymentFileStream deploymentStream, String overwrite) throws HumanTaskServiceException {
        try {
            this.setImportOverwrite(Boolean.valueOf(overwrite));
            new ImportReader(deploymentStream, this.resources, this.importOverwrite).read();
            this.resources.getPersistenceUtil().getEntityManager().close();
        }
        catch (Throwable e) {
            Utils.logException(e);
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()}, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportAll(String deploymentFile, String password) throws HumanTaskServiceException {
        DeploymentFileStream deploymentStream = null;
        try {
            deploymentStream = new DeploymentFileStream(deploymentFile, password);
            Writer writer = deploymentStream.getDeploymentFileWriter();
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            int versionNumber = this.version == null ? 0 : this.version.getDBVersion();
            String type = this.resources.getPersistenceUnit().getName();
            writer.write("<HumanTaskServiceDeployment date=\"" + new Date().toString() + "\" version=\"" + versionNumber + "\" type=\"" + type + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            this.exportAllNodes(writer);
            writer.write("</HumanTaskServiceDeployment>");
        }
        catch (Throwable e) {
            try {
                Utils.logException(e);
                throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()}, e);
            }
            catch (Throwable throwable) {
                try {
                    if (deploymentStream == null) throw throwable;
                    deploymentStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    Utils.logException(e2);
                    throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e2.getMessage()}, e2);
                }
            }
        }
        try {
            if (deploymentStream == null) return;
            deploymentStream.close();
            return;
        }
        catch (IOException e) {
            Utils.logException(e);
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()}, e);
        }
    }

    private void exportAllNodes(Writer writer) throws HumanTaskServiceException {
        TableTreeNodeExportVisitor exporter = new TableTreeNodeExportVisitor(writer);
        while (!this.resources.getTableTreeNodeFactory().getTreeNodes().isEmpty()) {
            this.resources.getTableTreeNodeFactory().visitNodes(exporter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block15: {
            DeploymentTool tool = null;
            try {
                ArgParser parser = new ArgParser(args, "Hts deployment", new String[]{CAM_UNAME, CAM_PWORD, CAM_NAMESPACE, PASSWORD, EXPORT_FILE_PATH, IMPORT_FILE_PATH, IMPORT_OVERWRITE, PERSISTENCE_UNIT, LIB_DIR});
                String importFile = parser.getProperty(IMPORT_FILE_PATH);
                String exportFile = parser.getProperty(EXPORT_FILE_PATH);
                String overwrite = parser.getProperty(IMPORT_OVERWRITE);
                String password = parser.getProperty(PASSWORD);
                String camUserName = parser.getProperty(CAM_UNAME);
                String camPassword = parser.getProperty(CAM_PWORD);
                String camNamespace = parser.getProperty(CAM_NAMESPACE);
                String persistenceUnitName = parser.getProperty(PERSISTENCE_UNIT);
                String libDir = parser.getProperty(LIB_DIR);
                PersistenceUnit persistenceUnit = PersistenceUnit.findByName(persistenceUnitName);
                if (persistenceUnit == null) {
                    persistenceUnit = PersistenceUnit.HUMANTASK_SERVICE;
                }
                DeploymentTool.setUpConfig();
                DeploymentTool.loadJDBCClasses(libDir);
                OpenJPAUtil.getConfigProperties().put("openjpa.DataCache", "true");
                OpenJPAUtil.getConfigProperties().put("openjpa.RemoteCommitProvider", "sjvm");
                OpenJPAUtil.initialise();
                OpenJPAUtil trx = new OpenJPAUtil(persistenceUnit);
                AbstractContext.setCurrentTransactionHandler(trx);
                trx.openSession();
                tool = new DeploymentTool(persistenceUnit, camNamespace, camUserName, camPassword);
                if (exportFile != null) {
                    tool.exportAll(exportFile, password);
                    break block15;
                }
                if (importFile != null) {
                    tool.importAll(importFile, password, overwrite);
                    break block15;
                }
                throw new Exception("bad deploy arguments");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (tool != null) {
                        tool.close();
                    }
                    AbstractContext.getCurrentTransactionHandler().closeSession();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setUpConfig() throws Exception {
        Node node;
        Element elem;
        CRNProperties crnConfig = CRNProperties.getInstance();
        m_iccl = CCLConfigurationFactory.getInstance();
        m_iccl.init();
        crnConfig.init(m_iccl);
        HTSCnfgProperties cmConfig = HTSCnfgProperties.getInstance();
        cmConfig.init(m_iccl);
        CMProperties.getInstance().init(m_iccl);
        String cmURL = cmConfig.getProperty("contentManager");
        if ((cmURL == null || cmURL.equals("")) && (elem = m_iccl.getValueElement("contentManagers", true, true)) != null && (node = elem.selectSingleNode("./crn:item")) != null) {
            cmURL = node.getText();
            HTSCnfgProperties.getInstance().setProperty("contentManager", cmURL);
            CMProperties.getInstance().setProperty("contentManager", cmURL);
        }
        Registry.registerService(TaskSearchProperties.class, new TaskSearchPropertiesOpenJPA());
        LogicalPeopleGroupSupportFactory.getInstance().readProperties();
    }

    private static void loadJDBCClasses(String libDir) throws Exception {
        File lib = null;
        if (libDir == null || "".equals(libDir)) {
            String libPath = "..$webapps$p2pd$WEB-INF$lib";
            libPath = libPath.replace("$", File.separator);
            lib = new File(libPath);
        } else {
            lib = new File(libDir);
        }
        DeploymentClassLoader dcl = DeploymentClassLoader.createDeploymentClassLoader(lib);
        JDBCConnectionProperties props = JDBCConnectionProperties.instance((String)"HTS");
        Class<?> driverClass = dcl.loadClass(props.getDriverStr());
        Driver driver = (Driver)driverClass.newInstance();
        ConnectionOpener.registerDriver((Driver)driver);
    }

    public boolean isImportOverwrite() {
        return this.importOverwrite;
    }

    public void setImportOverwrite(boolean importOverwrite) {
        this.importOverwrite = importOverwrite;
    }

    public DeploymentResources getResources() {
        return this.resources;
    }

    public void close() {
        this.resources.close();
    }
}

