/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment;

import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;

public class MetaDataSchemaTranslator {
    private List<Table> tables = new ArrayList<Table>();
    private Map<String, ClassMapping> mappingMap = new HashMap<String, ClassMapping>();
    private Map<String, ClassMapping> mappingMapByPojoName = new HashMap<String, ClassMapping>();

    MetaDataSchemaTranslator(PersistenceUnit persistenceUnit) {
        EntityManagerFactoryImpl emFactory = (EntityManagerFactoryImpl)OpenJPAUtil.getNamedEntityManagerFactory(persistenceUnit);
        JDBCConfiguration config = (JDBCConfiguration)emFactory.getConfiguration();
        Collection persistentClasses = config.getMappingRepositoryInstance().loadPersistentTypes(true, this.getClass().getClassLoader());
        if (persistentClasses != null && !persistentClasses.isEmpty()) {
            Iterator it = persistentClasses.iterator();
            while (it.hasNext()) {
                config.getMetaDataRepositoryInstance().getMetaData((Class)it.next(), this.getClass().getClassLoader(), false);
            }
        }
        ClassMapping[] metadata = (ClassMapping[])config.getMetaDataRepositoryInstance().getMetaDatas();
        this.processMetaData(metadata);
    }

    private void processMetaData(ClassMapping[] metadatas) {
        for (int i = 0; i < metadatas.length; ++i) {
            ClassMapping metaData = metadatas[i];
            Table table = metaData.getTable();
            this.tables.add(table);
            this.mappingMap.put(table.getName(), metaData);
            this.mappingMapByPojoName.put(metaData.getTypeAlias(), metaData);
        }
    }

    public ClassMapping getClassMappingByTableName(String name) {
        return this.mappingMap.get(name);
    }

    public ClassMapping getClassMappingByPojoName(String name) {
        return this.mappingMapByPojoName.get(name);
    }

    public Collection<ClassMapping> getMetaData() {
        return this.mappingMap.values();
    }

    public List<Table> getTables() {
        return this.tables;
    }
}

