/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment;

import com.ibm.cognos.internal.hts.util.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.meta.FieldMetaData;

public class MetaDataUtils {
    public static Object getPropertyValue(FieldMetaData propertyField, Object object) throws Exception {
        String property = propertyField.getName();
        String method_prefix = "get";
        if (Boolean.class.equals((Object)propertyField.getValue().getDeclaredType()) || Boolean.TYPE.equals(propertyField.getValue().getDeclaredType())) {
            method_prefix = !property.startsWith("is") ? "is" : "";
        }
        String getMethod = method_prefix + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method m = object.getClass().getMethod(getMethod, new Class[0]);
        return m.invoke(object, new Object[0]);
    }

    public static Object getPrimaryKey(Object persistenceCapable, ClassMapping mapping) throws Exception {
        Object id = null;
        FieldMetaData[] pkFields = mapping.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            id = MetaDataUtils.getPropertyValue(pkFields[i], persistenceCapable);
        }
        return id;
    }

    public static Method[] getMethodsWithAnnotation(Class<? extends Annotation> annotationClass, Object object) {
        Method[] methods = object.getClass().getMethods();
        ArrayList<Method> matchedMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            Annotation annotation = methods[i].getAnnotation(annotationClass);
            if (annotation == null) continue;
            matchedMethods.add(methods[i]);
        }
        return matchedMethods.toArray(new Method[matchedMethods.size()]);
    }

    public static Annotation getFieldWithAnnotation(Class<? extends Annotation> annotationClass, String fieldName, Object object) throws SecurityException, NoSuchFieldException {
        Annotation matchedAnnotation = null;
        Field[] fields = object.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length && matchedAnnotation == null; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            matchedAnnotation = fields[i].getAnnotation(annotationClass);
        }
        return matchedAnnotation;
    }

    public static Field[] getFieldsWithAnnotation(Class<? extends Annotation> annotationClass, Object object) {
        ArrayList<Field> matchedFields = new ArrayList<Field>();
        Field[] fields = object.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Annotation annotation = fields[i].getAnnotation(annotationClass);
            if (annotation == null) continue;
            matchedFields.add(fields[i]);
        }
        return matchedFields.toArray(new Field[matchedFields.size()]);
    }

    public static boolean hasMethodOrFieldWithAnnotation(Class<? extends Annotation> annotationClass, Object object) {
        return MetaDataUtils.getFieldsWithAnnotation(annotationClass, object).length > 0 || MetaDataUtils.getMethodsWithAnnotation(annotationClass, object).length > 0;
    }

    public static Object setPrimaryKey(Object persistenceCapable, ClassMapping mapping, Object value) throws Exception {
        Object id = null;
        FieldMetaData[] pkFields = mapping.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            id = MetaDataUtils.getPropertyValue(pkFields[i], persistenceCapable);
            MetaDataUtils.setPropertyValue(pkFields[i], persistenceCapable, value);
        }
        return id;
    }

    public static Object setPropertyValue(FieldMetaData propertyField, Object object, Object value) throws Exception {
        String property = propertyField.getName();
        Class valueclass = propertyField.getDeclaredType();
        String method_prefix = "set";
        try {
            value = MetaDataUtils.convertFromDeployment(value, propertyField.getTypeCode());
        }
        catch (Throwable e) {
            Utils.logException(e);
        }
        String getMethod = method_prefix + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method m = object.getClass().getMethod(getMethod, valueclass);
        return m.invoke(object, value);
    }

    public static Object convertToDeployment(Object val, int typeCode) {
        if (val == null) {
            return null;
        }
        switch (typeCode) {
            case 26: {
                Locale locale = (Locale)Locale.class.cast(val);
                return locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
            }
            case 14: {
                Date date = (Date)Date.class.cast(val);
                return "" + date.getTime();
            }
        }
        return String.valueOf(val);
    }

    public static Object convertFromDeployment(Object val, int typeCode) {
        if (val == null) {
            return null;
        }
        switch (typeCode) {
            case 24: {
                if (val instanceof String) {
                    return new BigDecimal(val.toString());
                }
                return val;
            }
            case 25: {
                if (val instanceof Number || val instanceof String) {
                    return new BigInteger(val.toString());
                }
                return val;
            }
            case 0: 
            case 16: {
                if (val instanceof String) {
                    return Boolean.valueOf(val.toString());
                }
                return val;
            }
            case 1: 
            case 17: {
                if (val instanceof String) {
                    return new Byte(val.toString());
                }
                return val;
            }
            case 2: 
            case 18: {
                if (val instanceof String) {
                    return new Character(val.toString().charAt(0));
                }
                return val;
            }
            case 14: {
                if (val instanceof String) {
                    Date date = new Date();
                    date.setTime(Long.parseLong((String)val));
                    return date;
                }
                return val;
            }
            case 3: 
            case 19: {
                if (val instanceof String) {
                    return new Double(val.toString());
                }
                return val;
            }
            case 4: 
            case 20: {
                if (val instanceof String) {
                    return new Float(val.toString());
                }
                return val;
            }
            case 5: 
            case 21: {
                if (val instanceof String) {
                    return new Integer(val.toString());
                }
                return val;
            }
            case 6: 
            case 22: {
                if (val instanceof String) {
                    return new Long(val.toString());
                }
                return val;
            }
            case 10: {
                if (val instanceof String) {
                    return new BigDecimal(val.toString());
                }
                return val;
            }
            case 7: 
            case 23: {
                if (val instanceof String) {
                    return new Short(val.toString());
                }
                return val;
            }
            case 9: {
                return val.toString();
            }
            case 26: {
                StringTokenizer tokenizer = new StringTokenizer(val.toString(), "_");
                String language = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
                String country = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
                String variant = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
                return new Locale(language, country, variant);
            }
        }
        return val;
    }
}

