/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.MetaDataUtils;
import com.ibm.cognos.internal.hts.deployment.exports.PojoExportGenerator;
import com.ibm.cognos.internal.hts.deployment.exports.TableSelect;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.Writer;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.meta.FieldMetaData;

public class LinkExportGenerator
extends PojoExportGenerator {
    private ClassMapping parent;
    private FieldMapping linkField;
    private ClassMapping child;

    LinkExportGenerator(ClassMapping parent, FieldMapping linkField, ClassMapping child, DeploymentResources resources) throws HumanTaskServiceException {
        super(parent.getTable(), resources);
        this.parent = parent;
        this.linkField = linkField;
        this.child = child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportAll(Writer writer) throws HumanTaskServiceException {
        EntityManagerFactory emf = OpenJPAUtil.getNamedEntityManagerFactory(this.exportResources.getPersistenceUnit());
        EntityManager em = emf.createEntityManager();
        try {
            TableSelect select = new TableSelect(this.parent.getTable(), this.exportResources);
            List<Object> linkParents = select.selectAll(em, this);
            for (Object object : linkParents) {
                this.writeObject(writer, object);
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getLocalizedMessage()});
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    public void writeObject(Writer writer, Object object) throws Exception {
        writer.write("<link name=\"" + this.table.getName() + "\">");
        writer.write("<ownerPojo name=\"" + this.parent.getTypeAlias() + "\" accessorProperty=\"" + this.linkField.getName() + "\">");
        writer.write(String.valueOf(MetaDataUtils.getPrimaryKey(object, this.parent)));
        writer.write("</ownerPojo>");
        List slaves = (List)MetaDataUtils.getPropertyValue((FieldMetaData)this.linkField, object);
        if (slaves != null) {
            for (Object slave : slaves) {
                writer.write("<childPojo name=\"" + this.child.getTypeAlias() + "\">");
                writer.write(String.valueOf(MetaDataUtils.getPrimaryKey(slave, this.child)));
                writer.write("</childPojo>");
            }
        }
        writer.write("</link>");
    }

    public ClassMapping getParent() {
        return this.parent;
    }

    public FieldMapping getLinkField() {
        return this.linkField;
    }

    public ClassMapping getChild() {
        return this.child;
    }
}

