/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.MetaDataUtils;
import com.ibm.cognos.internal.hts.deployment.exports.ExportGenerator;
import com.ibm.cognos.internal.hts.deployment.exports.LinkExportGenerator;
import com.ibm.cognos.internal.hts.deployment.exports.TableSelect;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.FixupStrategy;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.StringUtil;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.axis.client.Stub;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;

class PojoExportGenerator
implements ExportGenerator {
    protected Table table;
    protected DeploymentResources exportResources;
    private ClassMapping mapping;
    private Set<String> colNames = null;
    private Set<String> fKeySet = null;
    private List<LinkExportGenerator> linkExporters = new ArrayList<LinkExportGenerator>();

    PojoExportGenerator(Table table, DeploymentResources resources) {
        this.exportResources = resources;
        this.table = table;
        this.mapping = this.exportResources.getMetaDataSchemaTranslator().getClassMappingByTableName(table.getName());
        this.fKeySet = this.getForeignKeySet();
    }

    @Override
    public void exportAll(Writer writer) throws HumanTaskServiceException {
        EntityManagerFactory emf = OpenJPAUtil.getNamedEntityManagerFactory(this.exportResources.getPersistenceUnit());
        EntityManager em = emf.createEntityManager();
        int objectCount = 0;
        Utils.debug("exporting from " + this.table.getName() + ":" + new Date());
        try {
            TableSelect tableSelect = new TableSelect(this.table, this.exportResources);
            List<Object> objects = tableSelect.selectAll(em, this);
            int batchSize = tableSelect.getBatchSize();
            ArrayList<Object> buffer = new ArrayList<Object>();
            Iterator<Object> it = objects.iterator();
            while (it.hasNext()) {
                buffer.clear();
                while (it.hasNext() && buffer.size() < batchSize) {
                    Object object = it.next();
                    buffer.add(object);
                }
                HashSet<String> fixupIdSet = new HashSet<String>();
                Iterator it2 = buffer.iterator();
                while (it2.hasNext()) {
                    FixupStrategy strategy = this.exportResources.getFixupStrategyFactory().getFixupStrategy(it2.next());
                    strategy.collectFixupData(fixupIdSet);
                }
                Map<String, BaseClass> fixupCache = this.buildFixupCache(fixupIdSet);
                for (Object e : buffer) {
                    FixupStrategy strategy = this.exportResources.getFixupStrategyFactory().getFixupStrategy(e);
                    strategy.setFixupCache(fixupCache);
                    if (objectCount % 1000 == 0) {
                        Utils.debug("writing " + objectCount + " " + this.table.getName() + ":" + new Date());
                    }
                    ++objectCount;
                    this.writeObject(writer, e, strategy);
                }
            }
        }
        catch (Exception e) {
            Utils.logException(e);
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getLocalizedMessage()}, e);
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    private void writeObject(Writer writer, Object object, FixupStrategy strategy) throws Exception {
        writer.write("<pojo name=\"" + this.mapping.getTypeAlias() + "\">");
        FieldMetaData[] metaDatas = this.mapping.getDefinedFields();
        for (int i = 0; i < metaDatas.length; ++i) {
            this.writeProperty(writer, object, metaDatas[i]);
        }
        strategy.writeFixup(this.exportResources, writer);
        if (this.linkExporters != null) {
            for (LinkExportGenerator exportgen : this.linkExporters) {
                exportgen.writeObject(writer, object);
            }
        }
        writer.write("</pojo>");
    }

    protected void writeProperty(Writer writer, Object object, FieldMetaData metaData) throws Exception {
        ValueMapping valueMapping = (ValueMapping)metaData.getValue();
        Column[] cols = valueMapping.getColumns();
        String name = metaData.getName();
        String colName = "";
        String type = "";
        int javaType = -1;
        for (int i = 0; i < cols.length; ++i) {
            colName = cols[i].getName();
            type = Schemas.getJDBCName((int)cols[i].getType());
            javaType = cols[i].getJavaType();
        }
        if (!this.getColumnNamesSet().contains(colName)) {
            return;
        }
        boolean allowNulls = metaData.getNullValue() != 2;
        writer.write("<property name=\"" + name + "\" ");
        writer.write("type=\"" + type + "\" ");
        writer.write("columnName=\"" + colName + "\"");
        Object value = MetaDataUtils.getPropertyValue(metaData, object);
        if (this.getForeignKeySet().contains(colName)) {
            value = this.getForeignKeyIdValue(metaData.getValue(), value);
            writer.write(" fk=\"true\"");
        } else if (metaData.isDeclaredTypePC()) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_METADATA_MISMATCH, new Object[]{name});
        }
        if (allowNulls && value == null) {
            writer.write(" xsi:nil=\"true\"");
        }
        if (!allowNulls && value == null) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_METADATA_MISMATCH, new Object[]{name});
        }
        writer.write(">");
        if (value != null && !"".equals(value)) {
            Object valueToWrite = MetaDataUtils.convertToDeployment(value, javaType);
            writer.write(StringUtil.normalize(String.valueOf(valueToWrite), false));
        }
        writer.write("</property>");
    }

    protected Set<String> getForeignKeySet() {
        if (this.fKeySet != null) {
            return this.fKeySet;
        }
        ForeignKey[] fKeys = this.table.getForeignKeys();
        this.fKeySet = new HashSet<String>();
        for (int i = 0; i < fKeys.length; ++i) {
            Column[] cols = fKeys[i].getColumns();
            for (int j = 0; j < cols.length; ++j) {
                this.fKeySet.add(cols[j].getName());
            }
        }
        return this.fKeySet;
    }

    protected Set<String> getColumnNamesSet() {
        if (this.colNames != null) {
            return this.colNames;
        }
        Column[] columns = this.table.getColumns();
        this.colNames = new HashSet<String>();
        for (int i = 0; i < columns.length; ++i) {
            this.colNames.add(columns[i].getName());
        }
        return this.colNames;
    }

    protected Object getForeignKeyIdValue(ValueMetaData valueMetaData, Object propValue) throws Exception {
        ClassMapping valMetaData = (ClassMapping)valueMetaData.getDeclaredTypeMetaData();
        Object id = null;
        FieldMetaData[] pkMetas = valMetaData.getPrimaryKeyFields();
        if (pkMetas.length == 1 && propValue != null) {
            id = MetaDataUtils.getPropertyValue(pkMetas[0], propValue);
        }
        return id;
    }

    @Override
    public List<LinkExportGenerator> getLinkExporter() {
        return this.linkExporters;
    }

    @Override
    public void addLinkExporter(LinkExportGenerator linkExporter) {
        this.linkExporters.add(linkExporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, BaseClass> buildFixupCache(Set<String> fixupIds) throws HumanTaskServiceException {
        ContentManagerServiceClientPort cmPort = null;
        Object searchpath = null;
        HashMap<String, BaseClass> ret_value = new HashMap<String, BaseClass>();
        if (fixupIds.size() > 0) {
            try {
                JobBiBusHeaders headers = this.exportResources.getLoggedInHeader();
                cmPort = Client.instance().getContentManagerServiceClient(headers);
                AxisUtils.setHeader((Stub)cmPort.getBinding(), (BiBusHeader)headers.getBiBusHeader());
                QueryRequest[] requests = new QueryRequest[fixupIds.size()];
                int index = 0;
                for (String fixupId : fixupIds) {
                    QueryRequest request = new QueryRequest();
                    request.setSearch(ObjectModelUtil.getSearchPathFromGuid((String)fixupId).get_value());
                    request.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.storeID});
                    requests[index++] = request;
                }
                QueryReply[] replies = cmPort.queryMultiple(requests);
                if (replies != null) {
                    for (int i = 0; i < replies.length; ++i) {
                        BaseClass[] baseClasses;
                        QueryReply reply = replies[i];
                        if (reply == null || (baseClasses = reply.getQueryResult()) == null || baseClasses.length <= 0) continue;
                        for (int j = 0; j < baseClasses.length; ++j) {
                            BaseClass baseClass = baseClasses[j];
                            if (baseClass == null) continue;
                            String key = baseClass.getStoreID().getValue().get_value();
                            ret_value.put(key, baseClass);
                        }
                    }
                }
            }
            catch (Exception e) {
                Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()});
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
        }
        return ret_value;
    }
}

