/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.exports.ExportGenerator;
import com.ibm.cognos.internal.hts.deployment.exports.fetch.ExportFetchStrategy;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;

class TableSelect {
    private Table table;
    private DeploymentResources exportResources;
    private int batchSize = 100;

    TableSelect(Table table, DeploymentResources exportResources) {
        this.table = table;
        this.exportResources = exportResources;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public List<Object> selectAll(EntityManager em, ExportGenerator generator) throws HumanTaskServiceException {
        List objects = null;
        try {
            ClassMapping mapping = this.exportResources.getMetaDataSchemaTranslator().getClassMappingByTableName(this.table.getName());
            FieldMetaData[] metaDatas = mapping.getDefinedFields();
            Query query = em.createQuery("SELECT pojo FROM " + mapping.getTypeAlias() + " pojo");
            OpenJPAQuery kq = OpenJPAPersistence.cast((Query)query);
            JDBCFetchPlan fetch = (JDBCFetchPlan)kq.getFetchPlan();
            ExportFetchStrategy fetchStrategy = this.exportResources.getExportFetchStrategyFactory().getExportFetchStrategy(this.table);
            fetchStrategy.applyStrategy(fetch, metaDatas, generator, this.batchSize);
            objects = query.getResultList();
        }
        catch (Throwable e) {
            Utils.logException(e);
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()}, e);
        }
        return objects;
    }
}

