/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.exports.ExportGenerator;
import com.ibm.cognos.internal.hts.deployment.exports.LinkExportGenerator;
import com.ibm.cognos.internal.hts.deployment.exports.PojoExportGenerator;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;

class TableTreeNode {
    private List<TableTreeNode> childNodes = new ArrayList<TableTreeNode>();
    private List<TableTreeNode> parentNodes = new ArrayList<TableTreeNode>();
    private ClassMapping mapping;
    private ExportGenerator exportGen;
    private DeploymentResources resources;

    public TableTreeNode(ClassMapping mapping, DeploymentResources resources) {
        this.mapping = mapping;
        this.resources = resources;
    }

    public void populateChildren(Collection<TableTreeNode> allNodes) throws HumanTaskServiceException {
        this.childNodes = this.getChildForeignKeys(allNodes);
    }

    public void populateNode(Map<ClassMapping, TableTreeNode> allNodes) throws HumanTaskServiceException {
        for (TableTreeNode node : allNodes.values()) {
            if (node.mapping.equals((Object)this.mapping)) continue;
            ForeignKey fk = null;
            FieldMapping[] mappings = this.mapping.getFieldMappings();
            for (int i = 0; i < mappings.length && fk == null; ++i) {
                try {
                    ValueMapping vMapping = (ValueMapping)mappings[i].getValue();
                    fk = vMapping.getForeignKey();
                    fk = this.validateKey(fk, mappings[i].getTable(), node.getMapping().getTable());
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (fk == null || fk.getColumns().length <= 0 || fk.getPrimaryKeyTable() == null) continue;
            this.parentNodes.add(allNodes.get(node.getMapping()));
        }
        this.exportGen = new PojoExportGenerator(this.mapping.getTable(), this.resources);
    }

    public void populateLinks(Map<ClassMapping, TableTreeNode> allNodes) throws HumanTaskServiceException {
        FieldMapping[] mappings = this.mapping.getFieldMappings();
        for (int i = 0; i < mappings.length; ++i) {
            TableTreeNode parent;
            ClassMapping relatedMapping = mappings[i].getDeclaredTypeMapping();
            if (relatedMapping == null && mappings[i].getElementMapping() != null) {
                relatedMapping = mappings[i].getElementMapping().getTypeMapping();
            }
            if (relatedMapping == null || (parent = allNodes.get(relatedMapping)) == null || this.isRelated(parent)) continue;
            LinkExportGenerator linkExport = new LinkExportGenerator(this.mapping, mappings[i], relatedMapping, this.resources);
            this.addLinkExporter(linkExport);
            this.parentNodes.add(parent);
            parent.childNodes.add(this);
        }
    }

    public boolean isRelated(TableTreeNode child) {
        return this.parentNodes.contains(child) || this.childNodes.contains(child) || this.equals(child);
    }

    public ClassMapping getMapping() {
        return this.mapping;
    }

    public void addLinkExporter(LinkExportGenerator linkGen) {
        this.exportGen.addLinkExporter(linkGen);
    }

    public void exportAll(Writer writer) throws HumanTaskServiceException {
        this.exportGen.exportAll(writer);
    }

    public void remove() {
        List<TableTreeNode> children = this.getChildren();
        for (TableTreeNode tableTreeNode : children) {
            tableTreeNode.removeParent(this);
        }
        this.childNodes.clear();
        this.resources.getTableTreeNodeFactory().removeTableTreeNode(this.mapping.getTable());
    }

    public void removeParent(TableTreeNode parent) {
        this.parentNodes.remove(parent);
    }

    public List<TableTreeNode> getChildren() {
        return this.childNodes;
    }

    public List<TableTreeNode> getParents() {
        return this.parentNodes;
    }

    public boolean hasChildren() {
        return this.childNodes.size() > 0;
    }

    public boolean hasParents() {
        return this.parentNodes.size() > 0;
    }

    private List<TableTreeNode> getChildForeignKeys(Collection<TableTreeNode> allNodes) {
        ArrayList<TableTreeNode> children = new ArrayList<TableTreeNode>();
        for (TableTreeNode node : allNodes) {
            if (!node.parentNodes.contains(this)) continue;
            children.add(node);
        }
        return children;
    }

    private ForeignKey validateKey(ForeignKey fk, Table parent, Table potentialChild) {
        if (fk != null && !fk.getPrimaryKeyTable().equals(potentialChild)) {
            fk = null;
        }
        if (fk != null && !fk.getTable().equals(parent)) {
            fk = null;
        }
        if (parent.equals(potentialChild)) {
            fk = null;
        }
        return fk;
    }
}

