/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.exports.TableTreeNode;
import com.ibm.cognos.internal.hts.deployment.exports.TableTreeNodeVisitor;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Table;

public class TableTreeNodeFactory {
    public static String US_TABLE_PREFIX = "HTS";
    public static String US_BANNED_TABLE = "HTS_VERSION";
    public static String ANN_TABLE_PREFIX = "ANN";
    public static String ANN_BANNED_TABLE = "ANN_VERSION";
    public static String ANN_IDTABLE = "ANN_IDTABLE";
    private Map<String, TableTreeNode> tableNodes = new HashMap<String, TableTreeNode>();

    public TableTreeNodeFactory(DeploymentResources resources) throws HumanTaskServiceException {
        Collection<ClassMapping> classMappings = resources.getMetaDataSchemaTranslator().getMetaData();
        for (ClassMapping mapping : classMappings) {
            Table table = mapping.getTable();
            if (resources.getPersistenceUnit().equals((Object)PersistenceUnit.HUMANTASK_SERVICE) ? !table.getName().startsWith(US_TABLE_PREFIX) || table.getName().contains(US_BANNED_TABLE) : resources.getPersistenceUnit().equals((Object)PersistenceUnit.ANNOTATIONS) && (!table.getName().startsWith(ANN_TABLE_PREFIX) || table.getName().contains(ANN_BANNED_TABLE) || table.getName().contains(ANN_IDTABLE))) continue;
            TableTreeNode node = new TableTreeNode(mapping, resources);
            this.tableNodes.put(table.getName(), node);
        }
        Collection<TableTreeNode> nodes = this.tableNodes.values();
        HashMap<ClassMapping, TableTreeNode> mappingMap = new HashMap<ClassMapping, TableTreeNode>();
        for (TableTreeNode tableTreeNode : nodes) {
            mappingMap.put(tableTreeNode.getMapping(), tableTreeNode);
        }
        for (TableTreeNode node : nodes) {
            node.populateNode(mappingMap);
        }
        for (TableTreeNode node : nodes) {
            node.populateChildren(nodes);
        }
        for (TableTreeNode node : nodes) {
            node.populateLinks(mappingMap);
        }
    }

    public TableTreeNode getTableTreeNode(String tableName) {
        if (tableName == null) {
            return null;
        }
        return this.tableNodes.get(tableName);
    }

    public TableTreeNode getTableTreeNode(Table table) {
        if (table == null) {
            return null;
        }
        return this.tableNodes.get(table.getName());
    }

    public void removeTableTreeNode(Table table) {
        this.tableNodes.remove(table.getName());
    }

    public void visitNodes(TableTreeNodeVisitor visitor) throws HumanTaskServiceException {
        TableTreeNode[] nodes = this.tableNodes.values().toArray(new TableTreeNode[0]);
        for (int i = 0; i < nodes.length; ++i) {
            visitor.visitNode(nodes[i]);
        }
    }

    public Collection<TableTreeNode> getTreeNodes() {
        return this.tableNodes.values();
    }
}

