/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports.fetch;

import com.ibm.cognos.internal.hts.deployment.exports.ExportGenerator;
import com.ibm.cognos.internal.hts.deployment.exports.LinkExportGenerator;
import com.ibm.cognos.internal.hts.deployment.exports.fetch.ExportFetchStrategy;
import java.util.List;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.jdbc.FetchMode;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;

public class DefaultExportFetchStrategy
implements ExportFetchStrategy {
    private Table table;

    @Override
    public void applyStrategy(JDBCFetchPlan fetchPlan, FieldMetaData[] metaDatas, ExportGenerator generator, int batchSize) {
        for (int i = 0; i < metaDatas.length; ++i) {
            String colName = "";
            ValueMapping valueMapping = (ValueMapping)metaDatas[i].getValue();
            Column[] cols = valueMapping.getColumns();
            for (int j = 0; j < cols.length; ++j) {
                colName = cols[j].getName();
            }
            if (!this.containsColumnName(colName) || !JavaTypes.maybePC((ValueMetaData)metaDatas[i].getValue())) continue;
            fetchPlan.addField(metaDatas[i].getFullName());
        }
        List<LinkExportGenerator> linkExports = generator.getLinkExporter();
        if (linkExports != null) {
            for (LinkExportGenerator linkExport : linkExports) {
                FieldMapping metadata = linkExport.getLinkField();
                fetchPlan.addField(metadata.getFullName());
            }
        }
        fetchPlan.setFetchBatchSize(batchSize);
        fetchPlan.setEagerFetchMode(FetchMode.PARALLEL);
        fetchPlan.setMaxFetchDepth(1);
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void setTable(Table table) {
        this.table = table;
    }

    private boolean containsColumnName(String colName) {
        boolean ret_value = false;
        Column[] columns = this.table.getColumns();
        for (int i = 0; i < columns.length && !ret_value; ++i) {
            ret_value = columns[i].getName().equals(colName);
        }
        return ret_value;
    }
}

