/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports.fetch;

import com.ibm.cognos.internal.hts.deployment.exports.fetch.DefaultExportFetchStrategy;
import com.ibm.cognos.internal.hts.deployment.exports.fetch.ExportFetchStrategy;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.jdbc.schema.Table;

public class ExportFetchStrategyFactory {
    private Map<String, Class<? extends ExportFetchStrategy>> strategyMap = new HashMap<String, Class<? extends ExportFetchStrategy>>();

    public ExportFetchStrategy getExportFetchStrategy(Table table) throws HumanTaskServiceException {
        ExportFetchStrategy strategy = null;
        try {
            Class<? extends ExportFetchStrategy> strategyClazz = this.strategyMap.get(table.getName());
            strategy = strategyClazz != null ? strategyClazz.newInstance() : new DefaultExportFetchStrategy();
            strategy.setTable(table);
        }
        catch (Exception e) {
            Utils.logException(e);
            Utils.throwHumanTaskServiceException(e);
        }
        return strategy;
    }

    public void setExportFetchStrategy(String tableName, Class<? extends ExportFetchStrategy> strategyClass) {
        this.strategyMap.put(tableName, strategyClass);
    }
}

